/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.EqToken;

public class EqTypeToken
extends EqToken {
    public static final String TOKEN_NAME = "EQTYPE";

    @Override
    public String getTokenName() {
        return TOKEN_NAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String tempString;
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        String token = aTok.nextToken();
        int merge = 0;
        if (token.indexOf("MERGE") >= 0) {
            merge = EqTypeToken.returnMergeType(token);
            token = aTok.nextToken();
        }
        List<Object> eqList = new ArrayList();
        if ("Container".equals(token)) {
            for (Equipment eq : pc.getEquipmentListInOutputOrder(merge)) {
                if (!eq.acceptsChildren()) continue;
                eqList.add(eq);
            }
        } else {
            eqList = pc.getEquipmentOfTypeInOutputOrder(token, 3, merge);
        }
        int temp = -1;
        while (aTok.hasMoreTokens()) {
            if ("NOT".equalsIgnoreCase(token)) {
                eqList = EqTypeToken.listNotType(eqList, aTok.nextToken());
            } else if ("ADD".equalsIgnoreCase(token)) {
                eqList = EqTypeToken.listAddType(pc, eqList, aTok.nextToken());
            } else if ("IS".equalsIgnoreCase(token)) {
                eqList = EqTypeToken.listIsType(eqList, aTok.nextToken());
            } else {
                try {
                    temp = Integer.parseInt(token);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
            }
            if (temp >= 0) break;
            token = aTok.nextToken();
        }
        String string = tempString = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        if (temp >= 0 && temp < eqList.size()) {
            Equipment eq = (Equipment)eqList.get(temp);
            return EqTypeToken.getEqToken(pc, eq, tempString, aTok);
        }
        return "";
    }
}

