/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.Nature;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.QualifiedName;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbilityToken;
import pcgen.io.exporttoken.Token;
import pcgen.util.enumeration.View;

public class AbilityListToken
extends Token {
    private static final String DELIM = ", ";
    private MapToList<Ability, CNAbility> abilityMap = null;
    private PlayerCharacter lastPC = null;
    private int lastPCSerial;
    private String lastType = "";
    private AbilityCategory lastCategory = null;
    public static final String TOKENNAME = "ABILITYLIST";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String tokenString = aTok.nextToken();
        String catString = aTok.nextToken();
        AbilityCategory aCategory = SettingsHandler.getGame().getAbilityCategory(catString);
        return this.getTokenForCategory(pc, aTok, tokenString, aCategory);
    }

    protected String getTokenForCategory(PlayerCharacter pc, StringTokenizer aTok, String tokenString, AbilityCategory aCategory) {
        if (aCategory == null) {
            return "";
        }
        StringBuilder retString = new StringBuilder();
        if (this.lastPC != pc || !aCategory.equals(this.lastCategory) || this.lastPCSerial != pc.getSerial() || !tokenString.equals(this.lastType)) {
            this.abilityMap = this.getAbilityList(pc, aCategory);
            this.lastPC = pc;
            this.lastCategory = aCategory;
            this.lastPCSerial = pc.getSerial();
            this.lastType = tokenString;
        }
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> negate = new ArrayList<String>();
        String aspect = null;
        while (aTok.hasMoreTokens()) {
            int aspectInd;
            String typeStr = aTok.nextToken();
            int typeInd = typeStr.indexOf("TYPE=");
            if (typeInd != -1 && typeStr.length() > 5) {
                if (typeInd > 0) {
                    negate.add(typeStr.substring(typeInd + 5));
                } else {
                    types.add(typeStr.substring(typeInd + 5));
                }
            }
            if ((aspectInd = typeStr.indexOf("ASPECT=")) == -1 || typeStr.length() <= 7) continue;
            aspect = typeStr.substring(aspectInd + 7);
        }
        MapToList<Ability, CNAbility> aList = AbilityToken.buildAbilityList(types, negate, null, View.VISIBLE_EXPORT, aspect, this.abilityMap);
        boolean needComma = false;
        for (Ability ability : aList.getKeySet()) {
            if (needComma) {
                retString.append(DELIM);
            }
            needComma = true;
            retString.append(QualifiedName.qualifiedName(pc, aList.getListFor((Object)ability)));
        }
        return retString.toString();
    }

    protected MapToList<Ability, CNAbility> getAbilityList(PlayerCharacter pc, AbilityCategory aCategory) {
        HashMapToList listOfAbilities = new HashMapToList();
        Collection<AbilityCategory> allCats = SettingsHandler.getGame().getAllAbilityCategories();
        for (AbilityCategory aCat : allCats) {
            if (!AbilityCategory.ANY.equals(aCategory) && !aCat.getParentCategory().equals(aCategory)) continue;
            for (CNAbility cna : pc.getPoolAbilities(aCat, Nature.NORMAL)) {
                listOfAbilities.addToListFor((Object)cna.getAbility(), (Object)cna);
            }
        }
        return listOfAbilities;
    }
}

