/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.Constants;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.AbilityCategory;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.character.EquipSet;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.io.IOHandler;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.PCGVer2Creator;
import pcgen.io.PCGVer2Parser;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenPropBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.FileHelper;
import pcgen.util.Logging;

public final class PCGIOHandler
extends IOHandler {
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.errors);
        messages.addAll(this.warnings);
        return messages;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public static void buildSALIST(String aChoice, List<String> aAvailable, List<String> aBonus, PlayerCharacter currentPC) {
        String aString;
        String aPost = "";
        int iOffs = aChoice.indexOf(124, 7);
        if (iOffs < 0) {
            aString = aChoice;
        } else {
            aString = aChoice.substring(7, iOffs);
            aPost = aChoice.substring(iOffs + 1);
        }
        ArrayList<String> saNames = new ArrayList<String>();
        StringTokenizer aTok = new StringTokenizer(aString, ",");
        while (aTok.hasMoreTokens()) {
            saNames.add(aTok.nextToken());
        }
        List<SpecialAbility> aSAList = currentPC.getSpecialAbilityList();
        for (String name : saNames) {
            for (SpecialAbility sa : aSAList) {
                String aSA = sa.getKeyName();
                if (!aSA.startsWith(aString)) continue;
                String aVar = "";
                iOffs = aSA.indexOf(124);
                if (iOffs >= 0) {
                    aVar = aSA.substring(iOffs + 1);
                    iOffs = aSA.indexOf(37);
                    if (iOffs >= 0) {
                        aSA = aSA.substring(0, iOffs).trim();
                    }
                }
                if (aAvailable.contains(aSA)) continue;
                aAvailable.add(aSA);
                iOffs = aPost.indexOf(37);
                if (iOffs >= 0) {
                    aVar = aPost.substring(0, iOffs) + aVar + aPost.substring(iOffs + 1);
                }
                aBonus.add(aSA + "|" + aVar);
            }
        }
    }

    @Override
    public void read(PlayerCharacter pcToBeRead, InputStream in, boolean validate) {
        this.warnings.clear();
        List<String> lines = this.readPcgLines(in);
        boolean isPCGVersion2 = this.isPCGCersion2(lines);
        pcToBeRead.setImporting(true);
        String[] pcgLines = lines.toArray(new String[lines.size()]);
        if (isPCGVersion2) {
            PCGVer2Parser parser = new PCGVer2Parser(pcToBeRead);
            try {
                parser.parsePCG(pcgLines);
            }
            catch (PCGParseException pcgex) {
                Logging.errorPrint("Error loading character: " + pcgex.getMessage() + "\n Method " + pcgex.getMethod() + " was unable to parse line " + pcgex.getLine());
                this.errors.add(LanguageBundle.getFormattedString("in_pcgIoErrorReport", pcgex.getMessage()));
            }
            this.warnings.addAll(parser.getWarnings());
            pcToBeRead.setImporting(false);
            try {
                this.sanityChecks(pcToBeRead, parser);
            }
            catch (NumberFormatException ex) {
                this.errors.add(ex.getMessage() + Constants.LINE_SEPARATOR + "Method: sanityChecks");
            }
            pcToBeRead.setDirty(false);
        } else {
            this.errors.add("Cannot open PCG file");
        }
    }

    private boolean isPCGCersion2(List<String> lines) {
        for (String aLine : lines) {
            if (!aLine.startsWith("PCGVERSION")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readPcgLines(InputStream in) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String aLine;
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((aLine = br.readLine()) != null) {
                lines.add(aLine);
            }
        }
        catch (IOException ioe) {
            Logging.errorPrint("Exception in PCGIOHandler::read", ioe);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.read", e);
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(PlayerCharacter pcToBeWritten, GameMode mode, List<CampaignFacade> campaigns, OutputStream out) {
        String pcgString = new PCGVer2Creator(pcToBeWritten, mode, campaigns).createPCGString();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            bw.write(pcgString);
            bw.flush();
            pcToBeWritten.setDirty(false);
        }
        catch (IOException ioe) {
            Logging.errorPrint("Exception in PCGIOHandler::write", ioe);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.write", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PlayerCharacter pcToBeWritten, GameMode mode, List<CampaignFacade> campaigns, File outFile) {
        String pcgString = new PCGVer2Creator(pcToBeWritten, mode, campaigns).createPCGString();
        this.createBackupForFile(outFile);
        BufferedWriter bw = null;
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            bw.write(pcgString);
            bw.flush();
            pcToBeWritten.setDirty(false);
        }
        catch (IOException ioe) {
            Logging.errorPrint("Exception in PCGIOHandler::write", ioe);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.write", e);
            }
        }
    }

    private void sanityChecks(PlayerCharacter currentPC, PCGParser parser) {
        boolean fixMade = false;
        this.resolveDuplicateEquipmentSets(currentPC);
        currentPC.setCalcEquipmentList();
        currentPC.setCalcFollowerBonus();
        currentPC.calcActiveBonuses();
        int oldHp = currentPC.hitPoints();
        if (parser.isCalcFeatPoolAfterLoad()) {
            double baseFeatPool = parser.getBaseFeatPool();
            double featPoolBonus = currentPC.getRemainingFeatPoints(true);
            currentPC.setUserPoolBonus(AbilityCategory.FEAT, new BigDecimal(baseFeatPool -= featPoolBonus));
        }
        for (CNAbility aFeat : currentPC.getPoolAbilities(AbilityCategory.FEAT, Nature.NORMAL)) {
            if (!aFeat.getAbility().getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || currentPC.hasAssociations(aFeat)) continue;
            this.warnings.add("Multiple selection feat found with no selections (" + aFeat.getAbility().getDisplayName() + "). Correct on Feat tab.");
        }
        if (currentPC.hasClass()) {
            for (PCClass pcClass : currentPC.getClassSet()) {
                if (currentPC.getLevel(pcClass) < 1) continue;
                for (int i = 1; i <= currentPC.getLevel(pcClass); ++i) {
                    int iSides;
                    int baseSides = currentPC.getLevelHitDie(pcClass, i).getDie();
                    PCClassLevel pcl = currentPC.getActiveClassLevel(pcClass, i - 1);
                    Integer hp = currentPC.getHP(pcl);
                    int iRoll = hp == null ? 0 : hp;
                    if (iRoll <= (iSides = baseSides + (int)pcClass.getBonusTo("HD", "MAX", i, currentPC))) continue;
                    currentPC.setHP(pcl, iSides);
                    fixMade = true;
                }
            }
        }
        if (fixMade) {
            String message = "Fixed illegal value in hit points. Current character hit points: " + currentPC.hitPoints() + " not " + oldHp;
            this.warnings.add(message);
        }
        for (PCClass pcClass : currentPC.getClassSet()) {
            currentPC.calcActiveBonuses();
            currentPC.calculateKnownSpellsForClassLevel(pcClass);
        }
        currentPC.adjustMoveRates();
        currentPC.calcActiveBonuses();
        currentPC.setDirty(false);
    }

    private void resolveDuplicateEquipmentSets(PlayerCharacter currentPC) {
        boolean anyMoved = false;
        ArrayList<EquipSet> equipSetList = new ArrayList<EquipSet>(currentPC.getDisplay().getEquipSet());
        HashMap<String, EquipSet> idMap = new HashMap<String, EquipSet>();
        for (EquipSet es : equipSetList) {
            String idPath = es.getIdPath();
            if (idMap.containsKey(idPath)) {
                EquipSet existingEs = (EquipSet)idMap.get(idPath);
                EquipSet esToBeMoved = this.chooseItemToBeMoved(existingEs, es);
                if (esToBeMoved == null) {
                    this.warnings.add(String.format("Found two equipment items equipped to the path %s. Items were %s and %s.", idPath, es.getItem(), existingEs.getItem()));
                    continue;
                }
                currentPC.moveEquipSetToNewPath(esToBeMoved);
                EquipSet esStaying = esToBeMoved == es ? existingEs : es;
                for (int j = esToBeMoved.getItem().getContainedEquipmentCount() - 1; j >= 0; --j) {
                    Equipment containedItem = esToBeMoved.getItem().getContainedEquipment(j);
                    esToBeMoved.getItem().removeChild(currentPC, containedItem);
                    esStaying.getItem().insertChild(currentPC, containedItem);
                }
                Logging.log(Logging.WARNING, String.format("Moved item %s from path %s to %s as it clashed with %s", esToBeMoved.getItem(), idPath, esToBeMoved.getIdPath(), esToBeMoved == es ? existingEs.getItem() : es.getItem()));
                idMap.put(es.getIdPath(), es);
                idMap.put(existingEs.getIdPath(), existingEs);
                anyMoved = true;
                continue;
            }
            idMap.put(idPath, es);
        }
        if (anyMoved) {
            this.warnings.add("Some equipment was moved as it was incorrectly stored. Please see the log for details.");
        }
    }

    private EquipSet chooseItemToBeMoved(EquipSet equipSet1, EquipSet equipSet2) {
        if (!equipSet2.getItem().isContainer()) {
            return equipSet2;
        }
        if (!equipSet1.getItem().isContainer()) {
            return equipSet1;
        }
        return null;
    }

    public List<File> readCharacterFileList(File partyFile) {
        List lines;
        try {
            lines = FileUtils.readLines((File)partyFile, (String)"UTF-8");
        }
        catch (IOException ex) {
            Logging.errorPrint("Exception in IOHandler::read when reading", ex);
            return null;
        }
        if (lines.size() < 2) {
            Logging.errorPrint("Character files missing in " + partyFile.getAbsolutePath());
            return null;
        }
        String versionInfo = (String)lines.get(0);
        String charFiles = (String)lines.get(1);
        String[] files = charFiles.split(",");
        ArrayList<File> fileList = new ArrayList<File>();
        for (String fileName : files) {
            File characterFile = new File(partyFile.getParent(), fileName);
            if (!characterFile.exists()) {
                characterFile = new File(PCGenSettings.getPcgDir(), fileName);
            }
            if (!characterFile.exists()) {
                characterFile = new File(fileName);
            }
            if (characterFile.exists()) {
                fileList.add(characterFile);
                continue;
            }
            Logging.errorPrint("Character file does not exist: " + fileName);
        }
        return fileList;
    }

    public void write(File partyFile, List<File> characterFiles) {
        String versionLine = "VERSION:" + PCGenPropBundle.getVersionNumber();
        Object[] files = new String[characterFiles.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileHelper.findRelativePath(partyFile, characterFiles.get(i));
        }
        String filesLine = StringUtils.join(files, ',');
        try {
            FileUtils.writeLines((File)partyFile, (String)"UTF-8", Arrays.asList(versionLine, filesLine));
        }
        catch (IOException ex) {
            Logging.errorPrint("Could not save the party file: " + partyFile.getAbsolutePath(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceSelectionFacade readSources(File pcgFile) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(pcgFile);
            SourceSelectionFacade sourceSelectionFacade = this.internalReadSources(in);
            return sourceSelectionFacade;
        }
        catch (IOException ex) {
            Logging.errorPrint("Exception in IOHandler::read when reading", ex);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    Logging.errorPrint("Exception in IOHandler::readSources", e);
                }
                catch (NullPointerException e) {
                    Logging.errorPrint("Could not create file inputStream IOHandler::readSources", e);
                }
            }
        }
        return null;
    }

    private SourceSelectionFacade internalReadSources(InputStream in) {
        List<String> lines = this.readPcgLines(in);
        boolean isPCGVersion2 = this.isPCGCersion2(lines);
        String[] pcgLines = lines.toArray(new String[lines.size()]);
        if (isPCGVersion2) {
            PCGVer2Parser parser = new PCGVer2Parser(null);
            try {
                return parser.parcePCGSourceOnly(pcgLines);
            }
            catch (PCGParseException pcgex) {
                this.errors.add(pcgex.getMessage() + Constants.LINE_SEPARATOR + "Method: " + pcgex.getMethod() + '\n' + "Line: " + pcgex.getLine());
                this.warnings.addAll(parser.getWarnings());
            }
        } else {
            this.errors.add("Cannot open PCG file");
        }
        return null;
    }
}

