/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.treeview;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTree;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.util.treetable.AbstractTreeTableModel;
import pcgen.gui2.util.treetable.SortableTreeTableModel;
import pcgen.gui2.util.treetable.SortableTreeTableNode;
import pcgen.gui2.util.treetable.TreeTableNode;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.util.CollectionMaps;
import pcgen.util.ListMap;
import pcgen.util.Logging;

public class TreeViewTableModel<E>
extends AbstractTreeTableModel
implements SortableTreeTableModel {
    private final ListListener<E> listListener = new ListListener<E>(){

        @Override
        public void elementAdded(ListEvent<E> e) {
            TreeViewTableModel.this.addElement(e.getElement());
        }

        @Override
        public void elementRemoved(ListEvent<E> e) {
            TreeViewTableModel.this.removeElement(e.getElement());
        }

        @Override
        public void elementsChanged(ListEvent<E> e) {
            TreeViewTableModel.this.setElements(ListFacades.wrap(TreeViewTableModel.this.model));
        }

        @Override
        public void elementModified(ListEvent<E> e) {
            TreeViewTableModel.this.refreshElement(e.getElement());
        }
    };
    private final DataViewColumn namecolumn = new DataViewColumn(){

        @Override
        public String getName() {
            return TreeViewTableModel.this.selectedView.getViewName();
        }

        @Override
        public Class<?> getDataClass() {
            return TreeTableNode.class;
        }

        @Override
        public DataViewColumn.Visibility getVisibility() {
            return DataViewColumn.Visibility.ALWAYS_VISIBLE;
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    };
    protected final Map<E, List<?>> dataMap = new HashMap();
    protected List<? extends DataViewColumn> datacolumns;
    protected DataView<E> dataview;
    protected ListFacade<E> model = null;
    protected TreeView<? super E> selectedView = null;

    protected TreeViewTableModel() {
    }

    public TreeViewTableModel(DataView<E> dataView) {
        this.dataview = dataView;
        this.datacolumns = this.dataview.getDataColumns();
    }

    public void refreshData() {
        this.dataMap.clear();
        this.populateDataMap(ListFacades.wrap(this.model));
    }

    public final void setDataModel(ListFacade<E> model) {
        if (this.model != null) {
            this.model.removeListListener(this.listListener);
        }
        this.model = model;
        model.addListListener(this.listListener);
        this.setData(ListFacades.wrap(model));
    }

    private void setData(Collection<E> data) {
        this.dataMap.keySet().retainAll(data);
        this.populateDataMap(data);
        this.setSelectedTreeView(this.selectedView);
    }

    private void setElements(Collection<E> data) {
        HashSet<E> newData = new HashSet<E>(data);
        for (Object newKey : newData) {
            if (this.dataMap.containsKey(newKey)) continue;
            this.addElement(newKey);
        }
        HashSet<E> oldData = new HashSet<E>(this.dataMap.keySet());
        for (Object oldKey : oldData) {
            if (newData.contains(oldKey)) continue;
            this.removeElement(oldKey);
        }
    }

    private void removeElement(E elem) {
        if (this.dataMap.containsKey(elem) && this.selectedView != null) {
            TreeViewNode rootNode = (TreeViewNode)this.getRoot();
            for (TreeViewPath<? super E> treeViewPath : this.selectedView.getPaths(elem)) {
                rootNode.removeTreeViewPath(treeViewPath);
            }
            this.dataMap.remove(elem);
        }
    }

    private void addElement(E elem) {
        if (!this.dataMap.containsKey(elem) && this.selectedView != null) {
            this.dataMap.put(elem, this.dataview.getData(elem));
            TreeViewNode rootNode = (TreeViewNode)this.getRoot();
            for (TreeViewPath<? super E> treeViewPath : this.selectedView.getPaths(elem)) {
                rootNode.insertTreeViewPath(treeViewPath);
            }
        }
    }

    private void refreshElement(E elem) {
        if (this.dataMap.containsKey(elem) && this.selectedView != null) {
            this.dataMap.put(elem, this.dataview.getData(elem));
            TreeViewNode rootNode = (TreeViewNode)this.getRoot();
            for (TreeViewPath<? super E> treeViewPath : this.selectedView.getPaths(elem)) {
                rootNode.removeTreeViewPath(treeViewPath);
                rootNode.insertTreeViewPath(treeViewPath);
            }
        }
    }

    private void populateDataMap(Collection<E> data) {
        for (E obj : data) {
            if (this.dataMap.containsKey(obj)) continue;
            this.dataMap.put(obj, this.dataview.getData(obj));
        }
    }

    public final TreeView<? super E> getSelectedTreeView() {
        return this.selectedView;
    }

    public final void setSelectedTreeView(TreeView<? super E> view) {
        if (view != null) {
            this.selectedView = view;
            Vector<TreeViewPath<TreeViewPath<E>>> paths = new Vector<TreeViewPath<TreeViewPath<E>>>();
            for (E element : this.dataMap.keySet()) {
                for (TreeViewPath<E> treeViewPath : view.getPaths(element)) {
                    paths.add(treeViewPath);
                }
            }
            this.setRoot(new TreeViewNode(paths));
        }
    }

    @Override
    public final int getColumnCount() {
        return this.datacolumns.size() + 1;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.getDataColumn(column).getDataClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.getDataColumn(column).getName();
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (this.getDataColumn(column).isEditable()) {
            return column == 0 || this.dataMap.containsKey(((TreeViewNode)node).getUserObject());
        }
        return false;
    }

    private DataViewColumn getDataColumn(int column) {
        switch (column) {
            case 0: {
                return this.namecolumn;
            }
        }
        return this.datacolumns.get(column - 1);
    }

    @Override
    public final void sortModel(Comparator<List<?>> comparator) {
        TreeViewNode rootNode = (TreeViewNode)this.getRoot();
        rootNode.sortChildren(new SortableTreeTableModel.TreeNodeComparator(comparator));
        this.reload();
    }

    private final class TreeViewNode
    extends JTree.DynamicUtilTreeNode
    implements SortableTreeTableNode {
        private final int level;
        private Comparator<TreeTableNode> mostRecentComparator;

        public TreeViewNode(Vector<TreeViewPath<? super E>> paths) {
            this(0, null, paths);
        }

        private TreeViewNode(int level, Object name, Vector<TreeViewPath<? super E>> paths) {
            super(name, paths);
            this.mostRecentComparator = null;
            this.level = level;
            this.setAllowsChildren(true);
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        protected void loadChildren() {
            this.loadedChildren = true;
            if (this.childValue != null) {
                ListMap<Object, TreeViewPath, Vector> vectorMap = CollectionMaps.createListMap(HashMap.class, Vector.class);
                Vector vector = (Vector)this.childValue;
                for (TreeViewPath path : vector) {
                    if (path.getPathCount() <= this.level) continue;
                    Object key = path.getPathComponent(this.level);
                    vectorMap.add(key, path);
                }
                for (Object key : vectorMap.keySet()) {
                    vector = (Vector)vectorMap.get(key);
                    TreeViewNode child = vector.size() == 1 && ((TreeViewPath)vector.firstElement()).getPathCount() == this.level + 1 ? new TreeViewNode(this.level + 1, key, null) : new TreeViewNode(this.level + 1, key, vector);
                    child.setComparator(this.mostRecentComparator);
                    if (this.mostRecentComparator == null || this.children == null) {
                        this.add(child);
                        continue;
                    }
                    int index = Collections.binarySearch(this.children, child, this.mostRecentComparator);
                    if (index < 0) {
                        this.insert(child, -(index + 1));
                        continue;
                    }
                    this.insert(child, index);
                }
                this.childValue = null;
            }
        }

        public void removeTreeViewPath(TreeViewPath<? super E> path) {
            if (!this.loadedChildren) {
                Vector vector = (Vector)this.childValue;
                vector.remove(path);
                return;
            }
            Object levelObject = path.getPathComponent(this.level);
            if (levelObject == null) {
                return;
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeViewNode child = (TreeViewNode)this.getChildAt(i);
                if (child == null || !levelObject.equals(child.userObject)) continue;
                if (path.getPathCount() == this.level + 1) {
                    TreeViewTableModel.this.removeNodeFromParent(child);
                } else {
                    child.removeTreeViewPath(path);
                    if (!TreeViewTableModel.this.dataMap.containsKey(child.userObject) && child.getChildCount() == 0) {
                        TreeViewTableModel.this.removeNodeFromParent(child);
                    }
                }
                return;
            }
        }

        public void insertTreeViewPath(TreeViewPath<? super E> path) {
            TreeViewNode newchild;
            if (!this.loadedChildren) {
                Vector vector = (Vector)this.childValue;
                vector.add(path);
                return;
            }
            if (this.level >= path.getPathCount()) {
                Logging.errorPrint("Ignoring attempt to add child at level " + this.level + " which is beyond end of path " + path);
                return;
            }
            Object levelObject = path.getPathComponent(this.level);
            if (this.mostRecentComparator == null) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    TreeViewNode child = (TreeViewNode)this.getChildAt(i);
                    if (!levelObject.equals(child.userObject)) continue;
                    child.insertTreeViewPath(path);
                    return;
                }
            }
            if (path.getPathCount() == this.level + 1) {
                newchild = new TreeViewNode(this.level + 1, levelObject, null);
            } else {
                Vector vector = new Vector();
                vector.add(path);
                newchild = new TreeViewNode(this.level + 1, levelObject, vector);
            }
            newchild.setComparator(this.mostRecentComparator);
            if (this.mostRecentComparator == null || this.children == null) {
                TreeViewTableModel.this.insertNodeInto(newchild, this, this.getChildCount());
                return;
            }
            int index = Collections.binarySearch(this.children, newchild, this.mostRecentComparator);
            if (index >= 0) {
                TreeViewNode child = (TreeViewNode)this.getChildAt(index);
                if (child.getLevel() >= path.getPathCount()) {
                    TreeViewTableModel.this.insertNodeInto(newchild, this, index + 1);
                } else {
                    child.insertTreeViewPath(path);
                }
            } else {
                TreeViewTableModel.this.insertNodeInto(newchild, this, -(index + 1));
            }
        }

        @Override
        public boolean isLeaf() {
            if (this.level == 0) {
                return false;
            }
            if (!this.loadedChildren) {
                return this.childValue == null;
            }
            return this.getChildCount() == 0;
        }

        public void setComparator(Comparator<TreeTableNode> comparator) {
            this.mostRecentComparator = comparator;
        }

        @Override
        public void sortChildren(Comparator<TreeTableNode> comparator) {
            this.setComparator(comparator);
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            if (this.children != null) {
                Collections.sort(this.children, comparator);
                for (Object obj : this.children) {
                    TreeViewNode child = (TreeViewNode)obj;
                    child.setComparator(this.mostRecentComparator);
                    if (!child.loadedChildren) continue;
                    child.sortChildren(comparator);
                }
            }
        }

        @Override
        public List<Object> getValues() {
            Vector<Object> list = new Vector<Object>(TreeViewTableModel.this.getColumnCount());
            list.add(this.userObject);
            List<?> data = TreeViewTableModel.this.dataMap.get(this.userObject);
            if (data != null) {
                list.addAll(data);
            }
            list.setSize(TreeViewTableModel.this.getColumnCount());
            return list;
        }

        @Override
        public Object getValueAt(int column) {
            if (column == 0) {
                return this.userObject;
            }
            List<?> data = TreeViewTableModel.this.dataMap.get(this.userObject);
            if (data != null && column <= data.size()) {
                return data.get(column - 1);
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int column) {
            List<?> data = TreeViewTableModel.this.dataMap.get(this.userObject);
            if (data == null) {
                return;
            }
            data.set(column - 1, value);
        }
    }
}

