/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.treeview;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class TreeViewPath<E> {
    private final Object[] path;
    private final int length;

    public TreeViewPath(E pobj, Object path) {
        this(new Object[]{path, pobj}, 2);
    }

    public TreeViewPath(E pobj, Object ... path) {
        this(path, pobj);
    }

    public TreeViewPath(E pobj) {
        this(new Object[]{pobj}, 1);
    }

    public TreeViewPath(Object[] path, E ... pobjs) {
        if (path == null || path.length == 0 || pobjs == null || pobjs.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.length = path.length + pobjs.length;
        this.path = new Object[this.length];
        System.arraycopy(path, 0, this.path, 0, path.length);
        System.arraycopy(pobjs, 0, this.path, path.length, pobjs.length);
    }

    private TreeViewPath(Object[] path, int length) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.path = path;
        this.length = length;
    }

    public Object[] getPath() {
        return (Object[])this.path.clone();
    }

    public int getPathCount() {
        return this.length;
    }

    public Object getPathComponent(int element) {
        return this.path[element];
    }

    public E getLastPathComponent() {
        return (E)this.path[this.length - 1];
    }

    public int hashCode() {
        return this.getLastPathComponent().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeViewPath other = (TreeViewPath)obj;
        if (this.length != other.length) {
            return false;
        }
        return Arrays.equals(this.path, other.path);
    }

    public TreeViewPath<E> getParentPath() {
        return new TreeViewPath<E>(this.path, this.length - 1);
    }

    public TreeViewPath<E> getParentPath(int lastElement) {
        return new TreeViewPath<E>(this.path, lastElement + 1);
    }

    public TreeViewPath<E> pathByAddingParent(String singlePath) {
        Object[] parentPath = new Object[this.length + 1];
        parentPath[0] = singlePath;
        System.arraycopy(this.path, 0, parentPath, 1, this.length);
        return new TreeViewPath<E>(parentPath, this.length + 1);
    }

    public String toString() {
        return "TreeViewPath " + StringUtils.join(this.path, ", ");
    }
}

