/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import pcgen.base.lang.UnreachableError;
import pcgen.system.LanguageBundle;

public class InfoPane
extends JScrollPane {
    private JTextPane textPane;
    private TitledBorder titledBorder;

    public InfoPane() {
        this("in_source_info");
    }

    public InfoPane(String title) {
        super(20, 31);
        String name = title;
        if (title.startsWith("in_")) {
            name = LanguageBundle.getString(title);
        }
        this.titledBorder = BorderFactory.createTitledBorder(null, name, 2, 0);
        this.textPane = new JTextPane();
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createCompoundBorder(this.titledBorder, this.getBorder()));
        this.textPane.setEditable(false);
        this.setViewportView(this.textPane);
        this.textPane.setContentType("text/html");
        this.setPreferredSize(new Dimension(300, 200));
    }

    public String getTitle() {
        return this.titledBorder.getTitle();
    }

    public void setTitle(String title) {
        this.titledBorder.setTitle(title);
        this.validate();
        this.repaint();
    }

    public void setText(String text) {
        EditorKit kit = this.textPane.getEditorKit();
        Document newDoc = kit.createDefaultDocument();
        try {
            kit.read(new StringReader(text), newDoc, 0);
        }
        catch (IOException ex) {
            throw new UnreachableError((Throwable)ex);
        }
        catch (BadLocationException ex) {
            throw new UnreachableError((Throwable)ex);
        }
        this.textPane.setDocument(newDoc);
    }

    public void addHyperlinkListener(HyperlinkListener linkListener) {
        this.textPane.addHyperlinkListener(linkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener linkListener) {
        this.textPane.removeHyperlinkListener(linkListener);
    }
}

