/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.JTreeViewTable;

class SpellInfoHandler
implements ListSelectionListener {
    private CharacterFacade character;
    private final JTreeViewTable<?> availableTable;
    private final JTreeViewTable<?> selectedTable;
    private final InfoPane spellsPane;
    private String currText;

    public SpellInfoHandler(CharacterFacade character, JTreeViewTable<?> table1, JTreeViewTable<?> table2, InfoPane spellsPane) {
        this.spellsPane = spellsPane;
        this.availableTable = table1;
        this.selectedTable = table2;
        this.character = character;
        this.currText = "";
    }

    public void install() {
        this.availableTable.getSelectionModel().addListSelectionListener(this);
        this.selectedTable.getSelectionModel().addListSelectionListener(this);
        this.spellsPane.setText(this.currText);
    }

    public void uninstall() {
        this.availableTable.getSelectionModel().removeListSelectionListener(this);
        this.selectedTable.getSelectionModel().removeListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object obj = e.getSource() == this.availableTable.getSelectionModel() ? this.availableTable.getSelectedObject() : this.selectedTable.getSelectedObject();
            if (obj instanceof SpellSupportFacade.SpellNode) {
                String text;
                SpellSupportFacade.SpellNode node = (SpellSupportFacade.SpellNode)obj;
                this.currText = text = this.character.getInfoFactory().getHTMLInfo(node.getSpell());
                this.spellsPane.setText(text);
            } else if (obj instanceof SpellSupportFacade.RootNode) {
                SpellSupportFacade.RootNode node = (SpellSupportFacade.RootNode)obj;
                String text = this.character.getInfoFactory().getSpellBookInfo(node.getName());
                if (!StringUtils.isEmpty(text)) {
                    this.currText = text;
                    this.spellsPane.setText(text);
                }
            }
        }
    }
}

