/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.skill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;

public class SkillTreeViewModel
implements TreeViewModel<SkillFacade>,
DataView<SkillFacade>,
CharacterLevelsFacade.SkillBonusListener,
ListSelectionListener {
    private static final List<? extends DataViewColumn> columns = Arrays.asList(new DefaultDataViewColumn("in_iskTotal", Integer.class, true), new DefaultDataViewColumn("in_iskModifier", Integer.class, true), new DefaultDataViewColumn("in_skillRanks", Float.class, true, true), new DefaultDataViewColumn("in_classString", String.class, true), new DefaultDataViewColumn("in_skillSkillCost", String.class, SkillCost.CLASS.getCost() != SkillCost.CROSS_CLASS.getCost()), new DefaultDataViewColumn("in_descrip", String.class), new DefaultDataViewColumn("in_source", String.class));
    private final DefaultListFacade<TreeView<SkillFacade>> treeviews;
    private final CharacterFacade character;
    private final CharacterLevelsFacade levels;
    private final ListSelectionModel selectionModel;
    private FilteredTreeViewTable<CharacterFacade, SkillFacade> table;
    private boolean displayCostTrees = false;
    private final TreeView<SkillFacade> COST_NAME = new TreeView<SkillFacade>(){

        @Override
        public String getViewName() {
            return LanguageBundle.getString("in_skillCost_Name");
        }

        @Override
        public List<TreeViewPath<SkillFacade>> getPaths(SkillFacade pobj) {
            ArrayList<SkillCost> path = new ArrayList<SkillCost>();
            int index = SkillTreeViewModel.this.selectionModel.getMinSelectionIndex();
            if (index >= 0) {
                CharacterLevelFacade level = (CharacterLevelFacade)SkillTreeViewModel.this.levels.getElementAt(index);
                path.add(SkillTreeViewModel.this.levels.getSkillCost(level, pobj));
            }
            return Arrays.asList(SkillTreeViewModel.createTreeViewPath(pobj, path.toArray()));
        }
    };
    private final TreeView<SkillFacade> COST_TYPE_NAME = new TreeView<SkillFacade>(){

        @Override
        public String getViewName() {
            return LanguageBundle.getString("in_skillCost_Type_Name");
        }

        @Override
        public List<TreeViewPath<SkillFacade>> getPaths(SkillFacade pobj) {
            ArrayList<Object> path = new ArrayList<Object>();
            int index = SkillTreeViewModel.this.selectionModel.getMinSelectionIndex();
            if (index >= 0) {
                CharacterLevelFacade level = (CharacterLevelFacade)SkillTreeViewModel.this.levels.getElementAt(index);
                path.add((Object)SkillTreeViewModel.this.levels.getSkillCost(level, pobj));
            }
            path.add(pobj.getDisplayType());
            return Arrays.asList(SkillTreeViewModel.createTreeViewPath(pobj, path.toArray()));
        }
    };

    public SkillTreeViewModel(CharacterFacade character, ListSelectionModel selectionModel) {
        this.character = character;
        this.levels = character.getCharacterLevelsFacade();
        this.selectionModel = selectionModel;
        List<TreeView> views = Arrays.asList(SkillTreeView.NAME, SkillTreeView.TYPE_NAME, SkillTreeView.KEYSTAT_NAME, SkillTreeView.KEYSTAT_TYPE_NAME, this.COST_NAME, this.COST_TYPE_NAME);
        this.treeviews = new DefaultListFacade<TreeView>(views);
    }

    public void install(FilteredTreeViewTable<CharacterFacade, SkillFacade> ftvt) {
        this.table = ftvt;
        ftvt.setTreeViewModel(this);
        this.levels.addSkillBonusListener(this);
        this.selectionModel.addListSelectionListener(this);
    }

    public void uninstall() {
        this.table = null;
        this.levels.removeSkillBonusListener(this);
        this.selectionModel.removeListSelectionListener(this);
    }

    @Override
    public ListFacade<? extends TreeView<SkillFacade>> getTreeViews() {
        return this.treeviews;
    }

    @Override
    public int getDefaultTreeViewIndex() {
        return 1;
    }

    @Override
    public DataView<SkillFacade> getDataView() {
        return this;
    }

    @Override
    public ListFacade<SkillFacade> getDataModel() {
        return this.character.getDataSet().getSkills();
    }

    @Override
    public String getPrefsKey() {
        return "SkillTreeAvail";
    }

    @Override
    public List<?> getData(SkillFacade obj) {
        if (this.selectionModel.isSelectionEmpty()) {
            return Arrays.asList(0, 0, 0.0, null, 0, null, obj.getSource());
        }
        int index = this.selectionModel.getMinSelectionIndex();
        CharacterLevelFacade level = (CharacterLevelFacade)this.levels.getElementAt(index);
        CharacterLevelsFacade.SkillBreakdown skillBreakdown = this.levels.getSkillBreakdown(level, obj);
        return Arrays.asList(skillBreakdown.total, skillBreakdown.modifier, Float.valueOf(skillBreakdown.ranks), this.levels.getSkillCost(level, obj) == SkillCost.CLASS ? LanguageBundle.getString("in_yes") : LanguageBundle.getString("in_no"), this.levels.getSkillCost(level, obj).getCost(), this.character.getInfoFactory().getDescription(obj), obj.getSource());
    }

    @Override
    public List<? extends DataViewColumn> getDataColumns() {
        return columns;
    }

    @Override
    public void skillBonusChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        this.table.refreshModelData();
    }

    protected static TreeViewPath<SkillFacade> createTreeViewPath(SkillFacade pobj, Object ... path) {
        Object[] displayPath;
        if (path.length > 0 && StringUtils.isEmpty(String.valueOf(path[path.length - 1]))) {
            displayPath = new Object[path.length - 1];
            for (int i = 0; i < displayPath.length; ++i) {
                displayPath[i] = path[i];
            }
        } else {
            displayPath = path;
        }
        if (displayPath.length == 0) {
            return new TreeViewPath<SkillFacade>(pobj);
        }
        return new TreeViewPath<SkillFacade>(pobj, displayPath);
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting()) {
            return;
        }
        if (this.table.getSelectedTreeView() == this.COST_NAME || this.table.getSelectedTreeView() == this.COST_TYPE_NAME) {
            this.table.setTreeViewModel(this);
        } else {
            this.table.refreshModelData();
        }
    }

    private static enum SkillTreeView implements TreeView<SkillFacade>
    {
        NAME("in_Name"),
        TYPE_NAME("in_typeName"),
        KEYSTAT_NAME("in_keyStatName"),
        KEYSTAT_TYPE_NAME("in_keyStatTypeName");

        private String name;

        private SkillTreeView(String nameKey) {
            this.name = LanguageBundle.getString(nameKey);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<SkillFacade>> getPaths(SkillFacade pobj) {
            TreeViewPath<SkillFacade> path;
            switch (this) {
                case NAME: {
                    path = new TreeViewPath<SkillFacade>(pobj);
                    break;
                }
                case TYPE_NAME: {
                    path = SkillTreeViewModel.createTreeViewPath(pobj, pobj.getDisplayType());
                    break;
                }
                case KEYSTAT_NAME: {
                    path = new TreeViewPath<SkillFacade>(pobj, (Object)pobj.getKeyStat());
                    break;
                }
                case KEYSTAT_TYPE_NAME: {
                    path = SkillTreeViewModel.createTreeViewPath(pobj, pobj.getKeyStat(), pobj.getDisplayType());
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            return Arrays.asList(path);
        }
    }
}

