/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

class PortraitPane
extends JComponent {
    private static final int MAX_PORTRAIT_HEIGHT = 400;
    private float scale = 1.0f;
    private BufferedImage portrait;
    private Rectangle cropRect;

    public PortraitPane() {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public void setPortraitImage(BufferedImage portrait) {
        this.portrait = portrait;
        this.scale = 400.0f / (float)portrait.getHeight();
        this.repaint();
    }

    public void setCropRectangle(Rectangle newCropRect) {
        this.cropRect = new Rectangle(newCropRect);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        if (this.scale < 1.0f) {
            int width = (int)(this.scale * (float)this.portrait.getWidth());
            int height = (int)(this.scale * (float)this.portrait.getHeight());
            g.drawImage(this.portrait, insets.left, insets.top, width, height, this);
        } else {
            g.drawImage(this.portrait, insets.left, insets.top, this);
        }
        g.setColor(Color.BLACK);
        g.setXORMode(Color.WHITE);
        if (this.cropRect != null) {
            if (this.scale < 1.0f) {
                g.drawRect((int)((float)this.cropRect.x * this.scale) + insets.left, (int)((float)this.cropRect.y * this.scale) + insets.top, (int)((float)this.cropRect.width * this.scale), (int)((float)this.cropRect.height * this.scale));
            } else {
                g.drawRect(this.cropRect.x + insets.left, this.cropRect.y + insets.top, this.cropRect.width, this.cropRect.height);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int width = 0;
        int height = 0;
        if (insets != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        if (this.portrait != null) {
            if (this.scale < 1.0f) {
                width += (int)(this.scale * (float)this.portrait.getWidth());
                height += (int)(this.scale * (float)this.portrait.getHeight());
            } else {
                width += this.portrait.getWidth();
                height += this.portrait.getHeight();
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

