/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.sources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.LoadableFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.SortedListFacade;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.dialog.DataInstaller;
import pcgen.gui2.filter.FilteredListFacadeTableModel;
import pcgen.gui2.sources.AdvancedSourceSelectionPanel;
import pcgen.gui2.tools.CommonMenuText;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.tools.InfoPaneLinkAction;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FacadeListModel;
import pcgen.gui2.util.JTableEx;
import pcgen.gui2.util.table.TableUtils;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Comparators;

public class SourceSelectionDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private static final UIPropertyContext context = UIPropertyContext.createContext("SourceSelectionDialog");
    private static final String PROP_SELECTED_SOURCE = "selectedSource";
    private static final String LOAD_COMMAND = "Load";
    private static final String CANCEL_COMMAND = "Cancel";
    private static final String SAVE_COMMAND = "Save";
    private static final String DELETE_COMMAND = "Delete";
    private static final String HIDEUNHIDE_COMMAND = "Hide";
    private static final String INSTALLDATA_COMMAND = "Install";
    private final PCGenFrame frame;
    private QuickSourceSelectionPanel basicPanel;
    private AdvancedSourceSelectionPanel advancedPanel;
    private JTabbedPane tabs;
    private JPanel buttonPanel;
    private JButton loadButton;
    private JButton cancelButton;
    private JButton hideunhideButton;
    private JButton deleteButton;
    private JButton installDataButton;
    private JButton saveButton;
    private JCheckBox alwaysAdvancedCheck;

    public SourceSelectionDialog(PCGenFrame frame) {
        super((Frame)frame, true);
        this.frame = frame;
        this.setTitle(LanguageBundle.getString("in_mnuSourcesLoadSelect"));
        this.tabs = new JTabbedPane();
        this.basicPanel = new QuickSourceSelectionPanel();
        this.advancedPanel = new AdvancedSourceSelectionPanel(frame);
        this.buttonPanel = new JPanel();
        this.loadButton = new JButton();
        CommonMenuText.name(this.loadButton, "load", new Object[0]);
        this.cancelButton = new JButton();
        CommonMenuText.name(this.cancelButton, "cancel", new Object[0]);
        this.hideunhideButton = new JButton();
        CommonMenuText.name(this.hideunhideButton, "hideunhide", new Object[0]);
        this.deleteButton = new JButton();
        CommonMenuText.name(this.deleteButton, "delete", new Object[0]);
        this.installDataButton = new JButton();
        CommonMenuText.name(this.installDataButton, "mnuSourcesInstallData", new Object[0]);
        this.saveButton = new JButton();
        CommonMenuText.name(this.saveButton, "saveSelection", new Object[0]);
        this.alwaysAdvancedCheck = new JCheckBox(LanguageBundle.getString("in_sourceAlwaysAdvanced"), !UIPropertyContext.getInstance().initBoolean("SourceSelectionDialog.useBasic", true));
        this.setDefaultCloseOperation(1);
        this.initComponents();
        this.initDefaults();
        this.pack();
    }

    public static boolean skipSourceSelection() {
        return UIPropertyContext.getInstance().initBoolean("SourceSelectionDialog.skipOnStart", false);
    }

    private void initComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.tabs.add(LanguageBundle.getString("in_basic"), this.basicPanel);
        this.tabs.add(LanguageBundle.getString("in_advanced"), this.advancedPanel);
        this.tabs.addChangeListener(this);
        pane.add((Component)this.tabs, "Center");
        this.loadButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.loadButton);
        this.loadButton.setActionCommand(LOAD_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_COMMAND);
        this.deleteButton.setActionCommand(DELETE_COMMAND);
        this.saveButton.setActionCommand(SAVE_COMMAND);
        this.hideunhideButton.setActionCommand(HIDEUNHIDE_COMMAND);
        this.installDataButton.setActionCommand(INSTALLDATA_COMMAND);
        this.loadButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.hideunhideButton.addActionListener(this);
        this.installDataButton.addActionListener(this);
        Box buttons = Box.createHorizontalBox();
        buttons.add(this.buttonPanel);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.installDataButton);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.loadButton);
        buttons.add(Box.createHorizontalStrut(5));
        buttons.add(this.cancelButton);
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)buttons, "South");
        Utility.installEscapeCloseOperation(this);
    }

    private void initDefaults() {
        boolean useBasic = context.initBoolean("useBasic", true);
        SourceSelectionFacade selection = this.basicPanel.getSourceSelection();
        if (selection != null && useBasic) {
            this.basicPanel.makeSourceSelected(selection);
        } else {
            this.deleteButton.setEnabled(false);
        }
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        if (useBasic) {
            this.setBasicButtons();
            this.advancedPanel.setSourceSelection(this.basicPanel.getSourceSelection());
        } else {
            this.setAdvancedButtons();
            this.tabs.setSelectedIndex(1);
        }
    }

    void setDeleteEnabled(boolean enable) {
        this.deleteButton.setEnabled(enable);
    }

    void setLoadEnabled(boolean enable) {
        this.loadButton.setEnabled(enable);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            SourceSelectionFacade selection = this.basicPanel.getSourceSelection();
            this.deleteButton.setEnabled(selection.isModifiable());
            this.advancedPanel.setSourceSelection(selection);
        }
    }

    private void setBasicButtons() {
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.hideunhideButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.revalidate();
    }

    private void setAdvancedButtons() {
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.alwaysAdvancedCheck);
        this.buttonPanel.revalidate();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabs.getSelectedComponent() == this.basicPanel) {
            this.setBasicButtons();
        } else {
            this.setAdvancedButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(SAVE_COMMAND)) {
            final JList<SourceSelectionFacade> sourcesList = new JList<SourceSelectionFacade>();
            final JTextField nameField = new JTextField();
            SortedListFacade<SourceSelectionFacade> sources = new SortedListFacade<SourceSelectionFacade>(Comparators.toStringIgnoreCaseCollator(), FacadeFactory.getCustomSourceSelections());
            sourcesList.setModel(new FacadeListModel<SourceSelectionFacade>(sources));
            sourcesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    nameField.setText(sourcesList.getSelectedValue().toString());
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JScrollPane(sourcesList), "Center");
            panel.add((Component)nameField, "South");
            int ret = JOptionPane.showOptionDialog(this, panel, "Save the source selection as...", 2, -1, null, null, null);
            if (ret == 0) {
                String name = nameField.getText();
                List<CampaignFacade> selectedCampaigns = this.advancedPanel.getSelectedCampaigns();
                GameModeFacade selectedGameMode = this.advancedPanel.getSelectedGameMode();
                SourceSelectionFacade selection = null;
                for (SourceSelectionFacade sourceSelectionFacade : sources) {
                    if (!sourceSelectionFacade.toString().equals(name)) continue;
                    selection = sourceSelectionFacade;
                    break;
                }
                if (selection == null) {
                    selection = FacadeFactory.createCustomSourceSelection(name);
                }
                selection.setCampaigns(selectedCampaigns);
                selection.setGameMode(selectedGameMode);
                this.basicPanel.setSourceSelection(selection);
            }
        } else if (command.equals(DELETE_COMMAND)) {
            FacadeFactory.deleteCustomSourceSelection(this.basicPanel.getSourceSelection());
        } else if (command.equals(LOAD_COMMAND)) {
            this.fireSourceLoad();
        } else if (command.equals(INSTALLDATA_COMMAND)) {
            this.setVisible(false);
            DataInstaller di = new DataInstaller();
            di.setVisible(true);
        } else if (command.equals(HIDEUNHIDE_COMMAND)) {
            SourcesTableModel model = new SourcesTableModel();
            JTableEx table = new JTableEx(model);
            JTable rowTable = TableUtils.createDefaultTable();
            JScrollPane pane = TableUtils.createCheckBoxSelectionPane(table, rowTable);
            table.setShowGrid(false);
            table.setFocusable(false);
            table.setRowSelectionAllowed(false);
            table.toggleSort(0);
            rowTable.setRowSelectionAllowed(false);
            pane.setPreferredSize(new Dimension(300, 200));
            int ret = JOptionPane.showOptionDialog(this, pane, "Select Sources to be visible", 2, -1, null, null, null);
            if (ret == 0) {
                FacadeFactory.setDisplayedSources(model.getDisplayedSources());
            }
            model.dispose();
        } else {
            this.setVisible(false);
        }
    }

    private void fireSourceLoad() {
        SourceSelectionFacade selection = this.tabs.getSelectedComponent() == this.basicPanel ? this.basicPanel.getSourceSelection() : FacadeFactory.createSourceSelection(this.advancedPanel.getSelectedGameMode(), this.advancedPanel.getSelectedCampaigns());
        if (selection == null) {
            return;
        }
        List<CampaignFacade> campaigns = ListFacades.wrap(selection.getCampaigns());
        if (FacadeFactory.passesPrereqs(campaigns)) {
            this.setVisible(false);
            this.frame.loadSourceSelection(selection);
        } else {
            JOptionPane.showMessageDialog(this, "Some sources have unfulfilled prereqs", "Cannot Load Selected Sources", 1);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.advancedPanel.refreshDisplay();
        } else {
            UIPropertyContext.getInstance().setBoolean("SourceSelectionDialog.useBasic", !this.alwaysAdvancedCheck.isSelected());
        }
        super.setVisible(visible);
    }

    private class QuickSourceSelectionPanel
    extends JPanel
    implements ListSelectionListener {
        private static final String DEFAULT_SOURCE = "Pathfinder RPG for Players";
        private JList sourceList = new JList();
        private InfoPane infoPane = new InfoPane(LanguageBundle.getString("in_src_info"));
        private InfoPaneLinkAction linkAction = new InfoPaneLinkAction(this.infoPane);

        public QuickSourceSelectionPanel() {
            this.initComponents();
            this.initDefaults();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel(LanguageBundle.getString("in_qsrc_intro"));
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)label, "North");
            SortedListFacade<SourceSelectionFacade> sources = new SortedListFacade<SourceSelectionFacade>(Comparators.toStringIgnoreCaseCollator(), FacadeFactory.getDisplayedSourceSelections());
            this.sourceList.setModel(new FacadeListModel<SourceSelectionFacade>(sources));
            this.sourceList.setSelectionMode(0);
            this.sourceList.setCellRenderer(new SourceListCellRenderer());
            this.sourceList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        Point p = e.getPoint();
                        int index = QuickSourceSelectionPanel.this.sourceList.locationToIndex(p);
                        if (QuickSourceSelectionPanel.this.sourceList.getCellBounds(index, index).contains(p)) {
                            SourceSelectionDialog.this.fireSourceLoad();
                        }
                    }
                }
            });
            FlippingSplitPane mainPane = new FlippingSplitPane(1, "quickSrcMain");
            mainPane.setTopComponent(new JScrollPane(this.sourceList));
            this.linkAction.install();
            this.infoPane.setPreferredSize(new Dimension(800, 150));
            mainPane.setBottomComponent(this.infoPane);
            this.add((Component)mainPane, "Center");
        }

        private void initDefaults() {
            String defaultSelectedSource;
            final ListModel sortedModel = this.sourceList.getModel();
            int index = Collections.binarySearch(new AbstractList<Object>(){

                @Override
                public Object get(int idx) {
                    return sortedModel.getElementAt(idx);
                }

                @Override
                public int size() {
                    return sortedModel.getSize();
                }
            }, defaultSelectedSource = context.initProperty(SourceSelectionDialog.PROP_SELECTED_SOURCE, DEFAULT_SOURCE), Comparators.toStringIgnoreCaseCollator());
            if (index >= 0) {
                this.sourceList.setSelectedIndex(index);
            } else if (sortedModel.getSize() > 0) {
                this.sourceList.setSelectedIndex(0);
            }
            this.sourceList.addListSelectionListener(this);
        }

        public SourceSelectionFacade getSourceSelection() {
            return (SourceSelectionFacade)this.sourceList.getSelectedValue();
        }

        void setSourceSelection(SourceSelectionFacade source) {
            this.sourceList.setSelectedValue(source, true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SourceSelectionFacade selection = this.getSourceSelection();
            if (selection != null) {
                context.setProperty(SourceSelectionDialog.PROP_SELECTED_SOURCE, selection.toString());
                this.makeSourceSelected(selection);
            } else {
                SourceSelectionDialog.this.deleteButton.setEnabled(false);
            }
        }

        public void makeSourceSelected(SourceSelectionFacade selection) {
            SourceSelectionDialog.this.advancedPanel.setSourceSelection(selection);
            SourceSelectionDialog.this.deleteButton.setEnabled(selection.isModifiable());
            this.infoPane.setText(FacadeFactory.getCampaignInfoFactory().getHTMLInfo(selection));
        }

        private class SourceListCellRenderer
        extends DefaultListCellRenderer {
            private SourceListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setToolTipText("");
                if (value instanceof SourceSelectionFacade) {
                    SourceSelectionFacade selection = (SourceSelectionFacade)value;
                    if (selection.isModifiable()) {
                        this.setForeground(UIPropertyContext.getCustomItemColor());
                    }
                    if (selection.getLoadingState() == LoadableFacade.LoadingState.LOADED_WITH_ERRORS) {
                        this.setForeground(Color.LIGHT_GRAY);
                        this.setToolTipText(selection.getLoadingErrorMessage());
                    }
                }
                return this;
            }
        }
    }

    private static class SourcesTableModel
    extends FilteredListFacadeTableModel<SourceSelectionFacade> {
        private List<SourceSelectionFacade> displayedSources;

        public SourcesTableModel() {
            this.setDelegate(FacadeFactory.getSourceSelections());
            this.displayedSources = new ArrayList<SourceSelectionFacade>();
            this.displayedSources.addAll(ListFacades.wrap(FacadeFactory.getDisplayedSourceSelections()));
        }

        public void dispose() {
            this.setDelegate(null);
        }

        public SourceSelectionFacade[] getDisplayedSources() {
            return this.displayedSources.toArray(new SourceSelectionFacade[0]);
        }

        @Override
        protected Object getValueAt(SourceSelectionFacade element, int column) {
            if (column == -1) {
                return this.displayedSources.contains(element);
            }
            return element;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == -1) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == -1;
        }

        @Override
        public String getColumnName(int column) {
            return "Sources";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Boolean bool = (Boolean)aValue;
            SourceSelectionFacade source = (SourceSelectionFacade)this.sortedList.getElementAt(rowIndex);
            if (bool.booleanValue()) {
                this.displayedSources.add(source);
            } else {
                this.displayedSources.remove(source);
            }
        }
    }
}

