/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.kits;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.KitFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterUtilities;
import pcgen.gui2.filter.FilteredListFacade;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.models.QualifiedTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;

public class KitPanel
extends FlippingSplitPane {
    private final FilteredTreeViewTable<Object, KitFacade> availableTable;
    private final FilteredTreeViewTable<Object, KitFacade> selectedTable;
    private final JButton addButton;
    private final InfoPane infoPane;
    private final CharacterFacade character;
    private QualifiedTreeCellRenderer renderer;
    private AddAction addAction;
    private final FilterButton<Object, KitFacade> qFilterButton;

    public KitPanel(CharacterFacade character) {
        super("kit");
        this.character = character;
        this.availableTable = new FilteredTreeViewTable();
        this.selectedTable = new FilteredTreeViewTable();
        this.addButton = new JButton();
        this.infoPane = new InfoPane(LanguageBundle.getString("in_kitInfo"));
        this.renderer = new QualifiedTreeCellRenderer();
        this.addAction = new AddAction(character);
        this.qFilterButton = new FilterButton("KitQualified");
        this.initComponents();
        this.initDefaults();
    }

    private void initComponents() {
        this.renderer.setCharacter(this.character);
        FlippingSplitPane topPane = new FlippingSplitPane("kitTop");
        this.setTopComponent(topPane);
        this.setOrientation(0);
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        bar.addDisplayableFilter(this.qFilterButton);
        this.availableTable.setTreeViewModel(new KitTreeViewModel(this.character, true));
        this.availableTable.setTreeCellRenderer(this.renderer);
        JPanel availPanel = FilterUtilities.configureFilteredTreeViewPane(this.availableTable, bar);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.addButton.setHorizontalTextPosition(10);
        this.addButton.setAction(this.addAction);
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        topPane.setLeftComponent(availPanel);
        JPanel selPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.selectedTable.setDisplayableFilter(filterBar);
        this.selectedTable.setTreeViewModel(new KitTreeViewModel(this.character, false));
        this.selectedTable.setTreeCellRenderer(this.renderer);
        selPanel.add((Component)new JScrollPane(this.selectedTable), "Center");
        topPane.setRightComponent(selPanel);
        this.setBottomComponent(this.infoPane);
        this.setResizeWeight(0.75);
    }

    private void initDefaults() {
        InfoHandler infoHandler = new InfoHandler(this.character);
        this.availableTable.getSelectionModel().addListSelectionListener(infoHandler);
        this.selectedTable.getSelectionModel().addListSelectionListener(infoHandler);
        KitFilterHandler kitFilterHandler = new KitFilterHandler(this.character);
        kitFilterHandler.install();
        this.availableTable.addActionListener(this.addAction);
    }

    private static enum KitTreeView implements TreeView<KitFacade>
    {
        NAME(LanguageBundle.getString("in_nameLabel")),
        TYPE_NAME(LanguageBundle.getString("in_typeName")),
        SOURCE_NAME(LanguageBundle.getString("in_sourceName"));

        private String name;

        private KitTreeView(String name) {
            this.name = name;
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<KitFacade>> getPaths(KitFacade pobj) {
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<KitFacade>(pobj));
                }
                case TYPE_NAME: {
                    TreeViewPath<KitFacade> path = KitTreeView.createTreeViewPath(pobj, pobj.getDisplayType().split("\\."));
                    return Arrays.asList(path);
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<KitFacade>(pobj, (Object)pobj.getSource()));
                }
            }
            throw new InternalError();
        }

        protected static TreeViewPath<KitFacade> createTreeViewPath(KitFacade pobj, Object ... path) {
            if (path.length == 0) {
                return new TreeViewPath<KitFacade>(pobj);
            }
            return new TreeViewPath<KitFacade>(pobj, path);
        }
    }

    private static class KitTreeViewModel
    implements TreeViewModel<KitFacade>,
    DataView<KitFacade>,
    Filter<CharacterFacade, KitFacade>,
    ListListener<KitFacade> {
        private static final DefaultListFacade<? extends TreeView<KitFacade>> treeViews = new DefaultListFacade<KitTreeView>(Arrays.asList(KitTreeView.values()));
        private final List<DefaultDataViewColumn> columns;
        private final CharacterFacade character;
        private final boolean isAvailModel;
        private FilteredListFacade<CharacterFacade, KitFacade> kits;

        public KitTreeViewModel(CharacterFacade character, boolean isAvailModel) {
            this.character = character;
            this.isAvailModel = isAvailModel;
            if (isAvailModel) {
                this.kits = new FilteredListFacade();
                this.kits.setContext(character);
                this.kits.setFilter(this);
                DefaultListFacade<KitFacade> kitList = new DefaultListFacade<KitFacade>(character.getAvailableKits());
                this.kits.setDelegate(kitList);
                character.getKits().addListListener(this);
                this.columns = Arrays.asList(new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false));
            } else {
                this.kits = null;
                this.columns = Arrays.asList(new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false));
            }
        }

        @Override
        public ListFacade<? extends TreeView<KitFacade>> getTreeViews() {
            return treeViews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<KitFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<KitFacade> getDataModel() {
            if (this.isAvailModel) {
                return this.kits;
            }
            return this.character.getKits();
        }

        @Override
        public List<?> getData(KitFacade obj) {
            return Arrays.asList(this.character.getInfoFactory().getDescription(obj), obj.getSource());
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public void elementAdded(ListEvent<KitFacade> e) {
            this.kits.refilter();
        }

        @Override
        public void elementRemoved(ListEvent<KitFacade> e) {
            this.kits.refilter();
        }

        @Override
        public void elementsChanged(ListEvent<KitFacade> e) {
            this.kits.refilter();
        }

        @Override
        public void elementModified(ListEvent<KitFacade> e) {
            this.kits.refilter();
        }

        @Override
        public boolean accept(CharacterFacade context, KitFacade element) {
            return !element.isPermanent() || !context.getKits().containsElement(element);
        }

        @Override
        public String getPrefsKey() {
            return this.isAvailModel ? "KitTreeAvail" : "KitTreeSelected";
        }
    }

    private class AddAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_kitApply"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = KitPanel.this.availableTable.getSelectedData();
            for (Object kit : data) {
                if (!(kit instanceof KitFacade)) continue;
                this.character.addKit((KitFacade)kit);
                return;
            }
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;

        public InfoHandler(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object obj = null;
                if (e.getSource() == KitPanel.this.availableTable.getSelectionModel()) {
                    int selectedRow = KitPanel.this.availableTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = KitPanel.this.availableTable.getModel().getValueAt(selectedRow, 0);
                    }
                } else {
                    int selectedRow = KitPanel.this.selectedTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = KitPanel.this.selectedTable.getModel().getValueAt(selectedRow, 0);
                    }
                }
                if (obj instanceof KitFacade) {
                    KitPanel.this.infoPane.setText(this.character.getInfoFactory().getHTMLInfo((KitFacade)obj));
                }
            }
        }
    }

    private class KitFilterHandler {
        private final Filter<Object, KitFacade> qFilter = new Filter<Object, KitFacade>(){

            @Override
            public boolean accept(Object context, KitFacade element) {
                return KitFilterHandler.this.character.isQualifiedFor(element);
            }
        };
        private final CharacterFacade character;

        public KitFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            KitPanel.this.qFilterButton.setFilter(this.qFilter);
        }
    }
}

