/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.FilterHandler;
import pcgen.gui2.filter.FilteredTreeViewModel;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;

public class FilteredTreeViewTable<C, E>
extends JTreeViewTable<E>
implements FilterHandler {
    private static final TreeView<Object> searchView = new TreeView<Object>(){

        @Override
        public String getViewName() {
            return "Search";
        }

        @Override
        public List<TreeViewPath<Object>> getPaths(Object pobj) {
            return Collections.singletonList(new TreeViewPath<Object>(pobj));
        }
    };
    private boolean searchMode = false;
    private DisplayableFilter<C, E> filter = null;
    private FilteredTreeViewModel<C, E> filteredModel = null;
    private C context = null;
    private TreeView<? super E> tempView;

    public FilteredTreeViewTable() {
        this.setTableHeader(new FilteredTreeViewHeader());
    }

    @Override
    public void refilter() {
        this.filteredModel.refilter();
        this.updateDisplay();
    }

    @Override
    public void scrollToTop() {
        this.scrollRectToVisible(new Rectangle(this.getCellRect(0, 0, true)));
    }

    public void setContext(C context) {
        this.context = context;
        if (this.filteredModel != null) {
            this.filteredModel.setContext(context);
        }
    }

    public void setDisplayableFilter(DisplayableFilter<C, E> filter) {
        if (this.filter != null) {
            this.filter.setFilterHandler(null);
        }
        this.filter = filter;
        filter.setFilterHandler(this);
        if (this.filteredModel != null) {
            this.filteredModel.setFilter(filter);
        }
    }

    @Override
    public void setTreeViewModel(TreeViewModel<E> viewModel) {
        FilteredTreeViewModel oldModel = this.filteredModel;
        this.filteredModel = new FilteredTreeViewModel();
        this.filteredModel.setBaseModel(viewModel);
        if (this.filter != null) {
            this.filteredModel.setFilter(this.filter);
            this.filteredModel.setContext(this.context);
        }
        super.setTreeViewModel(this.filteredModel);
        if (oldModel != null) {
            oldModel.setBaseModel(null);
        }
    }

    @Override
    public void setSearchEnabled(boolean searchMode) {
        if (this.searchMode != searchMode) {
            this.searchMode = searchMode;
            if (this.treetableModel != null) {
                if (searchMode) {
                    this.tempView = this.treetableModel.getSelectedTreeView();
                    this.setTreeView(searchView);
                } else {
                    this.setTreeView(this.tempView);
                }
            }
        }
    }

    @Override
    public void refreshModelData() {
        super.refreshModelData();
        this.refilter();
    }

    public boolean isSearchEnabled() {
        return this.searchMode;
    }

    private class FilteredTreeViewHeader
    extends JTreeViewTable.JTreeViewHeader {
        private FilteredTreeViewHeader() {
            super(FilteredTreeViewTable.this);
        }

        @Override
        protected void maybeShowPopup(MouseEvent e) {
            if (!FilteredTreeViewTable.this.searchMode) {
                super.maybeShowPopup(e);
            }
        }
    }
}

