/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Campaign;
import pcgen.gui2.converter.LSTConverter;
import pcgen.gui2.converter.Loader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.system.PCGenPropBundle;
import pcgen.util.StringPClassUtil;

public class ObjectInjector {
    private final TripleKeyMapToList<URI, String, String, String> campaignData = new TripleKeyMapToList();
    private final DoubleKeyMapToList<URI, File, String> fileData = new DoubleKeyMapToList();
    private final Collection<Loader> loaders;
    private final File outDir;
    private final File rootDir;

    public ObjectInjector(LoadContext context, File outputDir, File rootDirectory, LSTConverter converter) {
        this.outDir = outputDir;
        this.rootDir = rootDirectory;
        this.loaders = converter.getInjectedLoaders();
        for (Loader l : this.loaders) {
            for (URI uri : converter.getInjectedURIs(l)) {
                for (CDOMObject o : converter.getInjectedObjects(l, uri)) {
                    Class<?> cl = o.getClass();
                    String className = StringPClassUtil.getStringFor(cl);
                    if ("EQMOD".equals(className)) {
                        className = "EQUIPMOD";
                    }
                    String fileName = className.toLowerCase() + "_516_conversion.lst";
                    context.setExtractURI(uri);
                    Collection<String> result = context.unparse(o);
                    String line = o.getDisplayName() + "\t" + StringUtil.join(result, (String)"\t");
                    if (result == null) continue;
                    this.fileData.addToListFor((Object)uri, (Object)this.getOutputFile(uri, fileName), (Object)line);
                    this.campaignData.addToListFor((Object)uri, (Object)className, (Object)fileName, (Object)line);
                }
            }
        }
    }

    private File getOutputFile(URI uri, String fileName) {
        File outFile = new File(this.getNewOutputName(uri).getParentFile(), fileName);
        if (outFile.exists()) {
            System.err.println("Won't overwrite: " + outFile);
        }
        return outFile;
    }

    private File getNewOutputName(URI uri) {
        File in = new File(uri);
        File base = this.findSubRoot(this.rootDir, in);
        String relative = in.toString().substring(base.toString().length() + 1);
        File actualRoot = this.generateCommonRoot(this.rootDir, this.outDir);
        String outString = this.outDir.getAbsolutePath().substring(actualRoot.getAbsolutePath().length());
        File outputFileSibling = new File(actualRoot, File.separator + outString + File.separator + relative);
        return outputFileSibling;
    }

    public void writeInjectedObjects(List<Campaign> list) throws IOException {
        ArrayList<URI> affectedURIs = new ArrayList<URI>();
        boolean first = true;
        for (Campaign campaign : list) {
            for (Loader l : this.loaders) {
                for (CampaignSourceEntry cse : l.getFiles(campaign)) {
                    first &= this.processWrite(campaign, this.campaignData, cse, first);
                    affectedURIs.add(cse.getURI());
                }
            }
        }
        for (URI uri : affectedURIs) {
            Set files = this.fileData.getSecondaryKeySet((Object)uri);
            if (files == null) continue;
            for (File f : files) {
                this.writeFile(f, this.fileData.getListFor((Object)uri, (Object)f));
            }
        }
    }

    private void writeFile(File f, List<String> lines) throws IOException {
        FileWriter writer = new FileWriter(f);
        writer.write(this.getFileHeader());
        for (String line : lines) {
            writer.write(line);
            writer.write("\n");
        }
        writer.write(this.getFileFooter());
        writer.close();
    }

    private String getFileHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("# This file was automatically created ");
        sb.append("during dataset conversion by PCGen ");
        sb.append(PCGenPropBundle.getVersionNumber());
        DateFormat df = DateFormat.getDateInstance(1);
        sb.append(" on ").append(df.format(new Date()));
        sb.append("\n# This file does not contain SOURCE information\n");
        return sb.toString();
    }

    private String getFileFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n#\n#EOF\n#\n");
        return sb.toString();
    }

    private boolean processWrite(Campaign campaign, TripleKeyMapToList<URI, String, String, String> toWrite, CampaignSourceEntry cse, boolean needHeader) throws IOException {
        URI uri = cse.getURI();
        Set classNames = toWrite.getSecondaryKeySet((Object)uri);
        if (classNames != null) {
            URI append = campaign.getSourceURI();
            File campaignFile = this.getNewOutputName(append);
            FileWriter writer = new FileWriter(campaignFile, true);
            if (needHeader) {
                writer.write(this.getCampaignInsertInfo());
            }
            for (String className : classNames) {
                for (String fileName : toWrite.getTertiaryKeySet((Object)uri, (Object)className)) {
                    CampaignSourceEntry writecse = cse.getRelatedTarget(fileName);
                    writer.write(className);
                    writer.write(":");
                    writer.write(writecse.getLSTformat());
                    writer.write("\n");
                }
            }
            writer.close();
            return false;
        }
        return true;
    }

    private String getCampaignInsertInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n#\n# The following file(s) were automatically added");
        sb.append(" during dataset conversion by PCGen ");
        try {
            ResourceBundle d_properties = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            sb.append(d_properties.getString("VersionNumber"));
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
        DateFormat df = DateFormat.getDateInstance(1);
        sb.append(" on ").append(df.format(new Date()));
        sb.append("\n#\n");
        return sb.toString();
    }

    private File findSubRoot(File root, File in) {
        if (in.getParentFile() == null) {
            return null;
        }
        if (in.getParentFile().getAbsolutePath().equals(root.getAbsolutePath())) {
            return in;
        }
        return this.findSubRoot(root, in.getParentFile());
    }

    private File generateCommonRoot(File a, File b) {
        if (a.equals(b)) {
            return a;
        }
        List<File> al = this.generateDirectoryHierarchy(a);
        List<File> bl = this.generateDirectoryHierarchy(b);
        File returnFile = null;
        for (File f : al) {
            if (!bl.contains(f)) break;
            returnFile = f;
        }
        return returnFile;
    }

    private List<File> generateDirectoryHierarchy(File a) {
        ArrayList<File> l = new ArrayList<File>();
        while (a != null) {
            l.add(0, a);
            a = a.getParentFile();
        }
        return l;
    }
}

