/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.ActionMap;
import javax.swing.JOptionPane;
import pcgen.cdom.content.Sponsor;
import pcgen.core.Globals;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.ItemFacade;
import pcgen.facade.core.KitFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.StatFacade;
import pcgen.facade.core.TemplateFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.PCGenUIManager;
import pcgen.gui2.coreview.CoreViewFrame;
import pcgen.gui2.dialog.CalculatorDialog;
import pcgen.gui2.dialog.DataInstaller;
import pcgen.gui2.dialog.DebugDialog;
import pcgen.gui2.dialog.ExportDialog;
import pcgen.gui2.dialog.KitSelectionDialog;
import pcgen.gui2.dialog.PrintPreviewDialog;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.PCGenAction;
import pcgen.gui2.tools.Utility;
import pcgen.system.CharacterManager;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public final class PCGenActionMap
extends ActionMap {
    public static final String FILE_COMMAND = "file";
    public static final String NEW_COMMAND = "file.new";
    public static final String OPEN_COMMAND = "file.open";
    public static final String OPEN_RECENT_COMMAND = "file.openrecent";
    public static final String CLOSE_COMMAND = "file.close";
    public static final String CLOSEALL_COMMAND = "file.closeall";
    public static final String SAVE_COMMAND = "file.save";
    public static final String SAVEAS_COMMAND = "file.saveas";
    public static final String SAVEALL_COMMAND = "file.saveall";
    public static final String REVERT_COMMAND = "file.reverttosaved";
    public static final String PARTY_COMMAND = "file.party";
    public static final String OPEN_PARTY_COMMAND = "file.party.open";
    public static final String OPEN_RECENT_PARTY_COMMAND = "file.party.openrecent";
    public static final String CLOSE_PARTY_COMMAND = "file.party.close";
    public static final String SAVE_PARTY_COMMAND = "file.party.save";
    public static final String SAVEAS_PARTY_COMMAND = "file.party.saveas";
    public static final String PRINT_COMMAND = "file.print";
    public static final String EXPORT_COMMAND = "file.export";
    public static final String EXIT_COMMAND = "file.exit";
    public static final String EDIT_COMMAND = "edit";
    public static final String UNDO_COMMAND = "edit.undo";
    public static final String REDO_COMMAND = "edit.redo";
    public static final String ADD_KIT_COMMAND = "edit.addkit";
    public static final String GENERATE_COMMAND = "edit.regenerate";
    public static final String TEMP_BONUS_COMMAND = "edit.tempbonus";
    public static final String EQUIPMENTSET_COMMAND = "edit.equipmentset";
    public static final String SOURCES_COMMAND = "sources";
    public static final String SOURCES_LOAD_COMMAND = "sources.load";
    public static final String SOURCES_LOAD_SELECT_COMMAND = "sources.select";
    public static final String SOURCES_RELOAD_COMMAND = "sources.reload";
    public static final String SOURCES_UNLOAD_COMMAND = "sources.unload";
    public static final String INSTALL_DATA_COMMAND = "sources.installData";
    public static final String TOOLS_COMMAND = "tools";
    public static final String FILTERS_COMMAND = "tools.filters";
    public static final String KIT_FILTERS_COMMAND = "tools.filters.kit";
    public static final String RACE_FILTERS_COMMAND = "tools.filters.race";
    public static final String TEMPLATE_FILTERS_COMMAND = "tools.filters.template";
    public static final String CLASS_FILTERS_COMMAND = "tools.filters.class";
    public static final String ABILITY_FILTERS_COMMAND = "tools.filters.ability";
    public static final String SKILL_FILTERS_COMMAND = "tools.filters.skill";
    public static final String EQUIPMENT_FILTERS_COMMAND = "tools.filters.equipment";
    public static final String SPELL_FILTERS_COMMAND = "tools.filters.spell";
    public static final String GENERATORS_COMMAND = "tools.generators";
    public static final String TREASURE_GENERATORS_COMMAND = "tools.generators.treasure";
    public static final String RACE_GENERATORS_COMMAND = "tools.generators.race";
    public static final String TEMPLATE_GENERATORS_COMMAND = "tools.generators.template";
    public static final String CLASS_GENERATORS_COMMAND = "tools.generators.class";
    public static final String STAT_GENERATORS_COMMAND = "tools.generators.stat";
    public static final String ABILITY_GENERATORS_COMMAND = "tools.generators.ability";
    public static final String SKILL_GENERATORS_COMMAND = "tools.generators.skill";
    public static final String EQUIPMENT_GENERATORS_COMMAND = "tools.generators.equipment";
    public static final String SPELL_GENERATORS_COMMAND = "tools.generators.spell";
    public static final String PREFERENCES_COMMAND = "tools.preferences";
    public static final String GMGEN_COMMAND = "tools.gmgen";
    public static final String LOG_COMMAND = "tools.log";
    public static final String LOGGING_LEVEL_COMMAND = "tools.loggingLevel";
    public static final String CALCULATOR_COMMAND = "tools.calculator";
    public static final String COREVIEW_COMMAND = "tools.coreview";
    public static final String HELP_COMMAND = "help";
    public static final String HELP_CONTEXT_COMMAND = "help.context";
    public static final String HELP_DOCS_COMMAND = "help.docs";
    public static final String HELP_OGL_COMMAND = "help.ogl";
    public static final String HELP_SPONSORS_COMMAND = "help.sponsors";
    public static final String HELP_TIPOFTHEDAY_COMMAND = "help.tod";
    public static final String HELP_ABOUT_COMMAND = "help.about";
    private final PCGenFrame frame;
    public static final String MNU_TOOLS = "mnuTools";
    public static final String MNU_TOOLS_PREFERENCES = "mnuToolsPreferences";
    public static final String MNU_EDIT = "mnuEdit";
    public static final String MNU_FILE = "mnuFile";

    public PCGenActionMap(PCGenFrame frame) {
        this.frame = frame;
        this.initActions();
    }

    private void initActions() {
        this.put(FILE_COMMAND, new FileAction());
        this.put(NEW_COMMAND, new NewAction());
        this.put(OPEN_COMMAND, new OpenAction());
        this.put(OPEN_RECENT_COMMAND, new OpenRecentAction());
        this.put(CLOSE_COMMAND, new CloseAction());
        this.put(CLOSEALL_COMMAND, new CloseAllAction());
        this.put(SAVE_COMMAND, new SaveAction());
        this.put(SAVEAS_COMMAND, new SaveAsAction());
        this.put(SAVEALL_COMMAND, new SaveAllAction());
        this.put(REVERT_COMMAND, new RevertAction());
        this.put(PARTY_COMMAND, new PartyAction());
        this.put(OPEN_PARTY_COMMAND, new OpenPartyAction());
        this.put(OPEN_RECENT_PARTY_COMMAND, new OpenRecentAction());
        this.put(CLOSE_PARTY_COMMAND, new ClosePartyAction());
        this.put(SAVE_PARTY_COMMAND, new SavePartyAction());
        this.put(SAVEAS_PARTY_COMMAND, new SaveAsPartyAction());
        this.put(PRINT_COMMAND, new PrintAction());
        this.put(EXPORT_COMMAND, new ExportAction());
        this.put(EXIT_COMMAND, new ExitAction());
        this.put(EDIT_COMMAND, new EditAction());
        this.put(UNDO_COMMAND, new UndoAction());
        this.put(REDO_COMMAND, new RedoAction());
        this.put(ADD_KIT_COMMAND, new AddKitAction());
        this.put(GENERATE_COMMAND, new GenerateAction());
        this.put(EQUIPMENTSET_COMMAND, new EquipmentSetAction());
        this.put(TEMP_BONUS_COMMAND, new TempBonusAction());
        this.put(PREFERENCES_COMMAND, new PreferencesAction());
        this.put(GMGEN_COMMAND, new GMGenAction());
        this.put(LOG_COMMAND, new DebugAction());
        this.put(LOGGING_LEVEL_COMMAND, new LoggingLevelAction());
        this.put(CALCULATOR_COMMAND, new CalculatorAction());
        this.put(COREVIEW_COMMAND, new CoreViewAction());
        this.put(INSTALL_DATA_COMMAND, new InstallDataAction());
        this.put(FILTERS_COMMAND, new FiltersAction());
        this.put(KIT_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersKit", KIT_FILTERS_COMMAND, KitFacade.class));
        this.put(RACE_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersRace", RACE_FILTERS_COMMAND, RaceFacade.class));
        this.put(TEMPLATE_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersTemplate", TEMPLATE_FILTERS_COMMAND, TemplateFacade.class));
        this.put(CLASS_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersClass", CLASS_FILTERS_COMMAND, ClassFacade.class));
        this.put(ABILITY_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersAbility", ABILITY_FILTERS_COMMAND, AbilityFacade.class));
        this.put(SKILL_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersSkill", SKILL_FILTERS_COMMAND, SkillFacade.class));
        this.put(EQUIPMENT_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersEquipment", EQUIPMENT_FILTERS_COMMAND, ItemFacade.class));
        this.put(SPELL_FILTERS_COMMAND, new DefaultFiltersAction("mnuToolsFiltersSpell", SPELL_GENERATORS_COMMAND, SpellFacade.class));
        this.put(SOURCES_COMMAND, new SourcesAction());
        this.put(SOURCES_LOAD_COMMAND, new LoadSourcesAction());
        this.put(SOURCES_LOAD_SELECT_COMMAND, new LoadSourcesSelectAction());
        this.put(SOURCES_RELOAD_COMMAND, new ReloadSourcesAction());
        this.put(SOURCES_UNLOAD_COMMAND, new UnloadSourcesAction());
        this.put(GENERATORS_COMMAND, new GeneratorsAction());
        this.put(TREASURE_GENERATORS_COMMAND, new TreasureGeneratorsAction());
        this.put(STAT_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsStat", STAT_GENERATORS_COMMAND, StatFacade.class));
        this.put(RACE_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsRace", RACE_GENERATORS_COMMAND, RaceFacade.class));
        this.put(TEMPLATE_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsTemplate", TEMPLATE_GENERATORS_COMMAND, TemplateFacade.class));
        this.put(CLASS_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsClass", CLASS_GENERATORS_COMMAND, ClassFacade.class));
        this.put(ABILITY_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsAbility", ABILITY_GENERATORS_COMMAND, AbilityFacade.class));
        this.put(SKILL_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsSkill", SKILL_GENERATORS_COMMAND, SkillFacade.class));
        this.put(EQUIPMENT_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsEquipment", EQUIPMENT_GENERATORS_COMMAND, ItemFacade.class));
        this.put(SPELL_GENERATORS_COMMAND, new DefaultGeneratorsAction("mnuToolsGeneratorsSpell", SPELL_GENERATORS_COMMAND, SpellFacade.class));
        this.put(TOOLS_COMMAND, new ToolsAction());
        this.put(HELP_COMMAND, new HelpAction());
        this.put(HELP_CONTEXT_COMMAND, new ContextHelpAction());
        this.put(HELP_DOCS_COMMAND, new DocsHelpAction());
        this.put(HELP_OGL_COMMAND, new OGLHelpAction());
        this.put(HELP_SPONSORS_COMMAND, new SponsorsHelpAction());
        this.put(HELP_TIPOFTHEDAY_COMMAND, new TipOfTheDayHelpAction());
        this.put(HELP_ABOUT_COMMAND, new AboutHelpAction());
    }

    private abstract class CharacterAction
    extends PCGenAction {
        private ReferenceFacade<?> ref;

        public CharacterAction(String prop) {
            this(prop, null, null, null);
        }

        public CharacterAction(String prop, Icons icon) {
            this(prop, null, null, icon);
        }

        public CharacterAction(String prop, String command, String accelerator) {
            this(prop, command, accelerator, null);
        }

        public CharacterAction(String prop, String command, Icons icon) {
            this(prop, command, null, icon);
        }

        public CharacterAction(String prop, String command, String accelerator, Icons icon) {
            super(prop, command, accelerator, icon, new Object[0]);
            this.ref = PCGenActionMap.this.frame.getSelectedCharacterRef();
            this.ref.addReferenceListener(new CharacterListener());
            this.setEnabled(this.ref.getReference() != null);
        }

        private class CharacterListener
        implements ReferenceListener<Object> {
            private CharacterListener() {
            }

            @Override
            public void referenceChanged(ReferenceEvent<Object> e) {
                CharacterAction.this.setEnabled(e.getNewReference() != null);
            }
        }
    }

    private class DefaultFiltersAction
    extends PCGenAction {
        private final Class<?> filterClass;

        public DefaultFiltersAction(String prop, String command, Class<?> filterClass) {
            super(prop, command);
            this.filterClass = filterClass;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class DefaultGeneratorsAction
    extends PCGenAction {
        private final Class<?> generatorClass;

        public DefaultGeneratorsAction(String prop, String command, Class<?> generatorClass) {
            super(prop, command);
            this.generatorClass = generatorClass;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class AboutHelpAction
    extends PCGenAction {
        public AboutHelpAction() {
            super("mnuHelpAbout", PCGenActionMap.HELP_ABOUT_COMMAND, Icons.About16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showAboutDialog();
        }
    }

    private class TipOfTheDayHelpAction
    extends PCGenAction {
        public TipOfTheDayHelpAction() {
            super("mnuHelpTipOfTheDay", PCGenActionMap.HELP_TIPOFTHEDAY_COMMAND, Icons.TipOfTheDay16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showTipsOfTheDay();
        }
    }

    private class SponsorsHelpAction
    extends PCGenAction {
        public SponsorsHelpAction() {
            super("mnuHelpSponsors", PCGenActionMap.HELP_SPONSORS_COMMAND);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<Sponsor> sponsors = Globals.getGlobalContext().getReferenceContext().getConstructedCDOMObjects(Sponsor.class);
            if (sponsors.size() > 1) {
                PCGenActionMap.this.frame.showSponsorsDialog();
                return;
            }
            JOptionPane.showMessageDialog(PCGenActionMap.this.frame, "There are no sponsors", "Missing Sponsors", 1);
        }
    }

    private class OGLHelpAction
    extends PCGenAction {
        public OGLHelpAction() {
            super("mnuHelpOGL", PCGenActionMap.HELP_OGL_COMMAND);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showOGLDialog();
        }
    }

    private class DocsHelpAction
    extends PCGenAction {
        public DocsHelpAction() {
            super("mnuHelpDocumentation", PCGenActionMap.HELP_DOCS_COMMAND, "F1", Icons.Help16, new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Utility.viewInBrowser(new File(ConfigurationSettings.getDocsDir(), "index.html"));
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not open docs in external browser", ex);
                JOptionPane.showMessageDialog(PCGenActionMap.this.frame, LanguageBundle.getString("in_menuDocsNotOpenMsg"), LanguageBundle.getString("in_menuDocsNotOpenTitle"), 0);
            }
        }
    }

    private class ContextHelpAction
    extends PCGenAction {
        public ContextHelpAction() {
            super("mnuHelpContext", PCGenActionMap.HELP_CONTEXT_COMMAND, Icons.ContextualHelp16);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class HelpAction
    extends PCGenAction {
        public HelpAction() {
            super("mnuHelp", PCGenActionMap.HELP_COMMAND);
        }
    }

    private class ToolsAction
    extends PCGenAction {
        public ToolsAction() {
            super(PCGenActionMap.MNU_TOOLS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class TreasureGeneratorsAction
    extends PCGenAction {
        public TreasureGeneratorsAction() {
            super("mnuToolsGeneratorsTreasure", PCGenActionMap.TREASURE_GENERATORS_COMMAND, "shortcut T");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class FiltersAction
    extends PCGenAction {
        public FiltersAction() {
            super("mnuToolsFilters");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class GeneratorsAction
    extends PCGenAction {
        public GeneratorsAction() {
            super("mnuToolsGenerators");
            this.setEnabled(false);
        }
    }

    private class UnloadSourcesAction
    extends PCGenAction
    implements ReferenceListener<SourceSelectionFacade> {
        public UnloadSourcesAction() {
            super("mnuSourcesUnload", PCGenActionMap.SOURCES_UNLOAD_COMMAND, "shortcut U");
            ReferenceFacade<SourceSelectionFacade> currentSourceSelectionRef = PCGenActionMap.this.frame.getCurrentSourceSelectionRef();
            currentSourceSelectionRef.addReferenceListener(this);
            this.checkEnabled(currentSourceSelectionRef.getReference());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.unloadSources();
        }

        @Override
        public void referenceChanged(ReferenceEvent<SourceSelectionFacade> e) {
            this.checkEnabled(e.getNewReference());
        }

        private void checkEnabled(SourceSelectionFacade sources) {
            this.setEnabled(sources != null && !sources.getCampaigns().isEmpty());
        }
    }

    private class ReloadSourcesAction
    extends PCGenAction
    implements ReferenceListener<SourceSelectionFacade> {
        public ReloadSourcesAction() {
            super("mnuSourcesReload", PCGenActionMap.SOURCES_RELOAD_COMMAND, "shift-shortcut R");
            ReferenceFacade<SourceSelectionFacade> currentSourceSelectionRef = PCGenActionMap.this.frame.getCurrentSourceSelectionRef();
            currentSourceSelectionRef.addReferenceListener(this);
            this.checkEnabled(currentSourceSelectionRef.getReference());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceSelectionFacade sources = PCGenActionMap.this.frame.getCurrentSourceSelectionRef().getReference();
            if (sources != null) {
                PCGenActionMap.this.frame.unloadSources();
                PCGenActionMap.this.frame.loadSourceSelection(sources);
            }
        }

        @Override
        public void referenceChanged(ReferenceEvent<SourceSelectionFacade> e) {
            this.checkEnabled(e.getNewReference());
        }

        private void checkEnabled(SourceSelectionFacade sources) {
            this.setEnabled(sources != null && !sources.getCampaigns().isEmpty());
        }
    }

    private class LoadSourcesSelectAction
    extends PCGenAction {
        public LoadSourcesSelectAction() {
            super("mnuSourcesLoadSelect", PCGenActionMap.SOURCES_LOAD_COMMAND, "shortcut L");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showSourceSelectionDialog();
        }
    }

    private class LoadSourcesAction
    extends PCGenAction {
        public LoadSourcesAction() {
            super("mnuSourcesLoad");
        }
    }

    private class SourcesAction
    extends PCGenAction {
        public SourcesAction() {
            super("mnuSources");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class ExitAction
    extends PCGenAction {
        public ExitAction() {
            super("mnuFileExit", PCGenActionMap.EXIT_COMMAND, "shortcut Q");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenUIManager.closePCGen();
        }
    }

    private class ExportAction
    extends CharacterAction {
        public ExportAction() {
            super("mnuFileExport", PCGenActionMap.EXPORT_COMMAND, "shift-shortcut P", Icons.Export16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportDialog.showExportDialog(PCGenActionMap.this.frame);
        }
    }

    private class PrintAction
    extends CharacterAction {
        public PrintAction() {
            super("mnuFilePrint", PCGenActionMap.PRINT_COMMAND, "shortcut P", Icons.Print16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrintPreviewDialog.showPrintPreviewDialog(PCGenActionMap.this.frame);
        }
    }

    private class SaveAsPartyAction
    extends CharacterAction {
        public SaveAsPartyAction() {
            super("mnuFilePartySaveAs", PCGenActionMap.SAVEAS_PARTY_COMMAND, Icons.SaveAs16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showSavePartyChooser();
        }
    }

    private class SavePartyAction
    extends CharacterAction {
        public SavePartyAction() {
            super("mnuFilePartySave", PCGenActionMap.SAVE_PARTY_COMMAND, Icons.Save16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PCGenActionMap.this.frame.saveAllCharacters() && !CharacterManager.saveCurrentParty()) {
                PCGenActionMap.this.frame.showSavePartyChooser();
            }
        }
    }

    private class ClosePartyAction
    extends PCGenAction {
        public ClosePartyAction() {
            super("mnuFilePartyClose", PCGenActionMap.CLOSE_PARTY_COMMAND, Icons.Close16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.closeAllCharacters();
        }
    }

    private class OpenPartyAction
    extends PCGenAction {
        public OpenPartyAction() {
            super("mnuFilePartyOpen", PCGenActionMap.OPEN_PARTY_COMMAND, Icons.Open16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showOpenPartyChooser();
        }
    }

    private class PartyAction
    extends PCGenAction {
        public PartyAction() {
            super("mnuFileParty");
        }
    }

    private class RevertAction
    extends CharacterAction {
        public RevertAction() {
            super("mnuFileRevertToSaved", PCGenActionMap.REVERT_COMMAND, "shortcut R");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.revertCharacter(PCGenActionMap.this.frame.getSelectedCharacterRef().getReference());
        }
    }

    private class SaveAllAction
    extends CharacterAction {
        public SaveAllAction() {
            super("mnuFileSaveAll", PCGenActionMap.SAVEALL_COMMAND, Icons.SaveAll16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.saveAllCharacters();
        }
    }

    private class SaveAsAction
    extends CharacterAction {
        public SaveAsAction() {
            super("mnuFileSaveAs", PCGenActionMap.SAVEAS_COMMAND, "shift-shortcut S", Icons.SaveAs16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showSaveCharacterChooser(PCGenActionMap.this.frame.getSelectedCharacterRef().getReference());
        }
    }

    private class SaveAction
    extends PCGenAction
    implements ReferenceListener<CharacterFacade> {
        private FileRefListener fileListener;

        public SaveAction() {
            super("mnuFileSave", PCGenActionMap.SAVE_COMMAND, "shortcut S", Icons.Save16, new Object[0]);
            this.fileListener = new FileRefListener();
            ReferenceFacade<CharacterFacade> ref = PCGenActionMap.this.frame.getSelectedCharacterRef();
            ref.addReferenceListener(this);
            this.checkEnabled(ref.getReference());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CharacterFacade pc = PCGenActionMap.this.frame.getSelectedCharacterRef().getReference();
            if (pc == null) {
                return;
            }
            PCGenActionMap.this.frame.saveCharacter(pc);
        }

        @Override
        public void referenceChanged(ReferenceEvent<CharacterFacade> e) {
            CharacterFacade oldRef = e.getOldReference();
            if (oldRef != null) {
                oldRef.getFileRef().removeReferenceListener(this.fileListener);
            }
            this.checkEnabled(e.getNewReference());
        }

        private void checkEnabled(CharacterFacade character) {
            if (character != null) {
                ReferenceFacade<File> file = character.getFileRef();
                file.addReferenceListener(this.fileListener);
                this.setEnabled(file.getReference() != null);
            } else {
                this.setEnabled(false);
            }
        }

        private class FileRefListener
        implements ReferenceListener<File> {
            private FileRefListener() {
            }

            @Override
            public void referenceChanged(ReferenceEvent<File> e) {
                SaveAction.this.setEnabled(e.getNewReference() != null);
            }
        }
    }

    private class CloseAllAction
    extends CharacterAction {
        public CloseAllAction() {
            super("mnuFileCloseAll", PCGenActionMap.CLOSEALL_COMMAND, Icons.CloseAll16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.closeAllCharacters();
        }
    }

    private class CloseAction
    extends CharacterAction {
        public CloseAction() {
            super("mnuFileClose", PCGenActionMap.CLOSE_COMMAND, "shortcut W", Icons.Close16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.closeCharacter(PCGenActionMap.this.frame.getSelectedCharacterRef().getReference());
        }
    }

    private class OpenRecentAction
    extends PCGenAction {
        public OpenRecentAction() {
            super("mnuOpenRecent");
        }
    }

    private class OpenAction
    extends PCGenAction {
        public OpenAction() {
            super("mnuFileOpen", PCGenActionMap.OPEN_COMMAND, "shortcut O", Icons.Open16, new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.showOpenCharacterChooser();
        }
    }

    private class NewAction
    extends PCGenAction {
        private ReferenceFacade<?> ref;

        public NewAction() {
            super("mnuFileNew", PCGenActionMap.NEW_COMMAND, "shortcut N", Icons.New16, new Object[0]);
            this.ref = PCGenActionMap.this.frame.getLoadedDataSetRef();
            this.ref.addReferenceListener(new SourceListener());
            this.setEnabled(this.ref.getReference() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenActionMap.this.frame.createNewCharacter();
        }

        private class SourceListener
        implements ReferenceListener<Object> {
            private SourceListener() {
            }

            @Override
            public void referenceChanged(ReferenceEvent<Object> e) {
                NewAction.this.setEnabled(e.getNewReference() != null);
            }
        }
    }

    private class FileAction
    extends PCGenAction {
        public FileAction() {
            super(PCGenActionMap.MNU_FILE);
        }
    }

    private class InstallDataAction
    extends PCGenAction {
        public InstallDataAction() {
            super("mnuSourcesInstallData");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataInstaller di = new DataInstaller();
            di.setVisible(true);
        }
    }

    private class LoggingLevelAction
    extends PCGenAction {
        public LoggingLevelAction() {
            super("mnuLoggingLevel");
        }
    }

    private class CoreViewAction
    extends CharacterAction {
        public CoreViewAction() {
            super("mnuToolsCoreView", PCGenActionMap.COREVIEW_COMMAND, "Shift-F11");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CharacterFacade cf = PCGenActionMap.this.frame.getSelectedCharacterRef().getReference();
            CoreViewFrame cvf = new CoreViewFrame(PCGenActionMap.this.frame, cf);
            cvf.setVisible(true);
        }
    }

    private class CalculatorAction
    extends PCGenAction {
        private CalculatorDialog dialog;

        public CalculatorAction() {
            super("mnuToolsCalculator", PCGenActionMap.CALCULATOR_COMMAND, "F11");
            this.dialog = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.dialog = new CalculatorDialog(PCGenActionMap.this.frame);
            }
            Utility.setDialogRelativeLocation(PCGenActionMap.this.frame, this.dialog);
            this.dialog.setVisible(true);
        }
    }

    private class DebugAction
    extends PCGenAction {
        private DebugDialog dialog;

        public DebugAction() {
            super("mnuToolsLog", PCGenActionMap.LOG_COMMAND, "F10");
            this.dialog = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.dialog = new DebugDialog(PCGenActionMap.this.frame);
            }
            Utility.setDialogRelativeLocation(PCGenActionMap.this.frame, this.dialog);
            this.dialog.setVisible(true);
        }
    }

    private static class GMGenAction
    extends PCGenAction {
        public GMGenAction() {
            super("mnuToolsGMGen", PCGenActionMap.GMGEN_COMMAND, null, Icons.gmgen_icon, "GMGen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenUIManager.displayGmGen();
        }
    }

    private class PreferencesAction
    extends PCGenAction {
        public PreferencesAction() {
            super(PCGenActionMap.MNU_TOOLS_PREFERENCES, Icons.Preferences16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenUIManager.displayPreferencesDialog();
        }
    }

    private class TempBonusAction
    extends PCGenAction {
        public TempBonusAction() {
            super("mnuEditTempBonus");
        }
    }

    private class EquipmentSetAction
    extends PCGenAction {
        public EquipmentSetAction() {
            super("mnuEditEquipmentSet");
        }
    }

    private class GenerateAction
    extends PCGenAction {
        public GenerateAction() {
            super("mnuEditGenerate");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class AddKitAction
    extends CharacterAction {
        public AddKitAction() {
            super("mnuEditAddKit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KitSelectionDialog kitDialog = new KitSelectionDialog(PCGenActionMap.this.frame, PCGenActionMap.this.frame.getSelectedCharacterRef().getReference());
            Utility.setDialogRelativeLocation(PCGenActionMap.this.frame, kitDialog);
            kitDialog.setVisible(true);
        }
    }

    private class RedoAction
    extends PCGenAction {
        public RedoAction() {
            super("mnuEditRedo", PCGenActionMap.REDO_COMMAND, "shortcut Y");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class UndoAction
    extends PCGenAction {
        public UndoAction() {
            super("mnuEditUndo", PCGenActionMap.UNDO_COMMAND, "shortcut Z");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class EditAction
    extends PCGenAction {
        public EditAction() {
            super(PCGenActionMap.MNU_EDIT);
        }
    }
}

