/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListListener;

public final class ListFacades {
    public static final ListFacade EMPTY_LIST = new EmptyList();

    private ListFacades() {
    }

    public static <T> ListFacade<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <T> List<T> wrap(final ListFacade<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.getElementAt(index);
            }

            @Override
            public int size() {
                return list.getSize();
            }
        };
    }

    private static class EmptyList
    implements ListFacade {
        private static Iterator iterator = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        private EmptyList() {
        }

        public void addListListener(ListListener listener) {
        }

        public Object getElementAt(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getSize() {
            return 0;
        }

        public void removeListListener(ListListener listener) {
        }

        @Override
        public Iterator iterator() {
            return iterator;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean containsElement(Object element) {
            return false;
        }
    }
}

