/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCSizeIntEQTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private String source;

    public PCSizeIntEQTermEvaluator(String expressionString, String source) {
        this.originalText = expressionString;
        this.source = source;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        int modSize = 0;
        Equipment eq = pc.getEquipmentNamed(this.source);
        if (eq != null) {
            CDOMSingleRef<WeaponProf> ref = eq.get(ObjectKey.WEAPON_PROF);
            if (ref != null) {
                String profName = ref.resolvesTo().getKeyName();
                StringBuilder sB = new StringBuilder("WEAPONPROF=");
                sB.append(profName);
                modSize = (int)pc.getTotalBonusTo(sB.toString(), "PCSIZE");
            }
            for (String eqType : eq.typeList()) {
                StringBuilder sB = new StringBuilder("WEAPONPROF=TYPE.");
                sB.append(eqType);
                int i = (int)pc.getTotalBonusTo(sB.toString(), "PCSIZE");
                if (modSize >= i) continue;
                modSize = i;
            }
        }
        return Float.valueOf((float)pc.getDisplay().sizeInt() + (float)modSize);
    }

    @Override
    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

