/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pcgen.core.GameMode;
import pcgen.core.SystemCollections;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.GeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.RaceGeneratorOption;

class OptionHandler
extends DefaultHandler {
    private List<GeneratorOption> theList;
    private GameMode theGameMode = null;
    private boolean theValidFlag = false;
    private GeneratorOption theCurrentOption = null;

    public OptionHandler(GameMode aMode, List<GeneratorOption> aList) {
        this.theGameMode = aMode;
        this.theList = aList;
    }

    @Override
    public void startElement(String uri, String localName, String aName, Attributes anAttrs) throws SAXException {
        if ("npcgen_options".equals(aName)) {
            if (anAttrs != null) {
                String gm = anAttrs.getValue("game_mode");
                if (!SystemCollections.getGameModeNamed(gm).equals(this.theGameMode)) {
                    throw new IllegalArgumentException("Incorrect game mode");
                }
                this.theValidFlag = true;
            }
            return;
        }
        if (!this.theValidFlag) {
            throw new SAXException("NPCGen.Options.InvalidFileFormat");
        }
        if ("align".equals(aName)) {
            this.theCurrentOption = new AlignGeneratorOption();
        } else if ("race".equals(aName)) {
            this.theCurrentOption = new RaceGeneratorOption();
        } else if ("gender".equals(aName)) {
            this.theCurrentOption = new GenderGeneratorOption();
        } else if ("class".equals(aName)) {
            this.theCurrentOption = new ClassGeneratorOption();
        } else if ("level".equals(aName)) {
            this.theCurrentOption = new LevelGeneratorOption();
        } else if ("choice".equals(aName)) {
            int weight = 1;
            String weightStr = anAttrs.getValue("weight");
            if (weightStr != null) {
                weight = Integer.parseInt(weightStr);
            }
            this.theCurrentOption.addChoice(weight, anAttrs.getValue("value"));
        }
        if (!"choice".equals(aName)) {
            this.theCurrentOption.setName(anAttrs.getValue("name"));
            this.theList.add(this.theCurrentOption);
        }
    }
}

