/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.enumeration.Gender;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassData;
import pcgen.core.npcgen.ClassDataParser;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.GeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.OptionsParser;
import pcgen.core.npcgen.RaceGeneratorOption;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.spell.Spell;
import pcgen.system.ConfigurationSettings;

public class Configuration {
    private static List<Configuration> theConfigurations = new ArrayList<Configuration>();
    private static Configuration theDefaultConfiguration = new Configuration();
    private GameMode theMode = null;
    private List<GeneratorOption> theGeneratorOptions = new ArrayList<GeneratorOption>();
    private Map<String, ClassData> theClassData = new HashMap<String, ClassData>();
    private static File optionsDir = new File(ConfigurationSettings.getSystemsDir() + File.separator + "npcgen" + File.separator + "options");
    private static File classDataDir = new File(ConfigurationSettings.getSystemsDir() + File.separator + "npcgen" + File.separator + "classdata");

    public static Configuration get(GameMode aMode) {
        for (Configuration config : theConfigurations) {
            if (!config.theMode.equals(aMode)) continue;
            return config;
        }
        Configuration config = new Configuration();
        config.theMode = aMode;
        try {
            File[] classDataFiles;
            File[] fileNames;
            OptionsParser parser = new OptionsParser(aMode);
            for (File file : fileNames = optionsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File aDir, String aName) {
                    return aName.toLowerCase().endsWith(".xml");
                }
            })) {
                List<GeneratorOption> options = parser.parse(file);
                config.theGeneratorOptions.addAll(options);
            }
            ClassDataParser classParser = new ClassDataParser(aMode);
            for (File file : classDataFiles = classDataDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File aDir, String aName) {
                    return aName.toLowerCase().endsWith(".xml");
                }
            })) {
                List<ClassData> classData = classParser.parse(file);
                for (ClassData cd : classData) {
                    config.theClassData.put(cd.getPCClass().getKeyName(), cd);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return theDefaultConfiguration;
        }
        theConfigurations.add(config);
        return config;
    }

    public List<AlignGeneratorOption> getAlignmentOptions() {
        ArrayList<AlignGeneratorOption> ret = new ArrayList<AlignGeneratorOption>();
        for (GeneratorOption opt : this.theGeneratorOptions) {
            if (!(opt instanceof AlignGeneratorOption)) continue;
            ret.add((AlignGeneratorOption)opt);
        }
        for (PCAlignment align : Globals.getContext().getReferenceContext().getOrderSortedCDOMObjects(PCAlignment.class)) {
            boolean included = false;
            for (AlignGeneratorOption option : ret) {
                if (!option.getName().equals(align.getDisplayName())) continue;
                included = true;
                break;
            }
            if (align.getKeyName().equals("None") || included) continue;
            AlignGeneratorOption opt = new AlignGeneratorOption();
            opt.setName(align.getDisplayName());
            opt.addChoice(1, align.getKeyName());
            ret.add(opt);
        }
        return ret;
    }

    public List<RaceGeneratorOption> getRaceOptions() {
        ArrayList<RaceGeneratorOption> ret = new ArrayList<RaceGeneratorOption>();
        for (GeneratorOption opt : this.theGeneratorOptions) {
            if (!(opt instanceof RaceGeneratorOption)) continue;
            ret.add((RaceGeneratorOption)opt);
        }
        for (Race race : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Race.class)) {
            RaceGeneratorOption opt = new RaceGeneratorOption();
            opt.setName(race.getDisplayName());
            opt.addChoice(1, race.getKeyName());
            ret.add(opt);
        }
        return ret;
    }

    public List<GenderGeneratorOption> getGenderOptions() {
        ArrayList<GenderGeneratorOption> ret = new ArrayList<GenderGeneratorOption>();
        for (GeneratorOption opt : this.theGeneratorOptions) {
            if (!(opt instanceof GenderGeneratorOption)) continue;
            ret.add((GenderGeneratorOption)opt);
        }
        for (Gender gender : Gender.values()) {
            GenderGeneratorOption opt = new GenderGeneratorOption();
            opt.setName(gender.toString());
            opt.addChoice(1, gender.toString());
            ret.add(opt);
        }
        return ret;
    }

    public List<ClassGeneratorOption> getClassOptions() {
        ArrayList<ClassGeneratorOption> ret = new ArrayList<ClassGeneratorOption>();
        for (GeneratorOption opt : this.theGeneratorOptions) {
            if (!(opt instanceof ClassGeneratorOption)) continue;
            ret.add((ClassGeneratorOption)opt);
        }
        for (PCClass pcClass : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCClass.class)) {
            ClassGeneratorOption opt = new ClassGeneratorOption();
            opt.setName(pcClass.getDisplayName());
            opt.addChoice(1, pcClass.getKeyName());
            ret.add(opt);
        }
        return ret;
    }

    public List<LevelGeneratorOption> getLevelOptions() {
        ArrayList<LevelGeneratorOption> ret = new ArrayList<LevelGeneratorOption>();
        for (GeneratorOption opt : this.theGeneratorOptions) {
            if (!(opt instanceof LevelGeneratorOption)) continue;
            ret.add((LevelGeneratorOption)opt);
        }
        for (int i = 1; i <= 20; ++i) {
            GeneratorOption opt;
            opt = new LevelGeneratorOption();
            opt.setName(String.valueOf(i));
            ((LevelGeneratorOption)opt).addChoice(1, String.valueOf(i));
            ret.add((LevelGeneratorOption)opt);
        }
        return ret;
    }

    public WeightedCollection<PCStat> getStatWeights(String aKey) {
        ClassData data = this.theClassData.get(aKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getStatWeights();
    }

    public WeightedCollection<SkillChoice> getSkillWeights(String aKey) {
        ClassData data = this.theClassData.get(aKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getSkillWeights();
    }

    public WeightedCollection<Ability> getAbilityWeights(String aKey, AbilityCategory aCategory) {
        ClassData data = this.theClassData.get(aKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getAbilityWeights(aCategory);
    }

    public WeightedCollection<Deity> getDeityWeights(String aKey) {
        ClassData data = this.theClassData.get(aKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getDeityWeights();
    }

    public WeightedCollection<Domain> getDomainWeights(String aDeityKey, String aClassKey) {
        ClassData data = this.theClassData.get(aClassKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getDomainWeights(aDeityKey);
    }

    public WeightedCollection<Spell> getKnownSpellWeights(PlayerCharacter pc, String aClassKey, int aLevel) {
        ClassData data = this.theClassData.get(aClassKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getKnownSpellWeights(aLevel, pc);
    }

    public WeightedCollection<Spell> getPreparedSpellWeights(String aClassKey, int aLevel, PlayerCharacter pc) {
        ClassData data = this.theClassData.get(aClassKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getPreparedSpellWeights(aLevel, pc);
    }

    public WeightedCollection<String> getSubClassWeights(String aClassKey) {
        ClassData data = this.theClassData.get(aClassKey);
        if (data == null) {
            data = new ClassData(null);
        }
        return data.getSubClassWeights();
    }
}

