/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;

public class BonusCalc {
    private static boolean dontRecurse = false;

    public static int getStatMod(PObject po, PCStat stat, PlayerCharacter aPC) {
        return (int)BonusCalc.charBonusTo(po, "STAT", stat.getKeyName(), aPC);
    }

    public static double bonusTo(PObject po, String aType, String aName, Object obj, Collection<BonusObj> aBonusList, PlayerCharacter aPC) {
        if (aBonusList == null || aBonusList.size() == 0) {
            return 0.0;
        }
        double retVal = 0.0;
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        String aTypePlusName = aType + '.' + aName + '.';
        if (!dontRecurse && po instanceof Ability && AbilityUtilities.isFeat(obj) && !Globals.checkRule("FEATPRE")) {
            dontRecurse = true;
            boolean returnZero = false;
            if (!po.qualifies(aPC, po)) {
                returnZero = true;
            }
            dontRecurse = false;
            if (returnZero) {
                return 0.0;
            }
        }
        int iTimes = 1;
        if (aPC != null && "VAR".equals(aType)) {
            iTimes = Math.max(1, aPC.getConsolidatedAssociationList(po).size());
        }
        for (BonusObj bonus : aBonusList) {
            String bString = bonus.toString().toUpperCase();
            if (aPC != null && !aPC.getConsolidatedAssociationList(po).isEmpty()) {
                int span = 4;
                int idx = bString.indexOf("%VAR");
                if (idx == -1) {
                    idx = bString.indexOf("%LIST|");
                    span = 5;
                }
                if (idx < 0) continue;
                String firstPart = bString.substring(0, idx);
                String secondPart = bString.substring(idx + span);
                for (String assoc : aPC.getConsolidatedAssociationList(po)) {
                    String xString = new StringBuilder(50).append(firstPart).append(assoc).append(secondPart).toString().toUpperCase();
                    retVal += BonusCalc.calcBonus(po, xString, aType, aName, aTypePlusName, obj, iTimes, bonus, aPC);
                }
                continue;
            }
            retVal += BonusCalc.calcBonus(po, bString, aType, aName, aTypePlusName, obj, iTimes, bonus, aPC);
        }
        return retVal;
    }

    public static double charBonusTo(PObject po, String aType, String aName, PlayerCharacter aPC) {
        return BonusCalc.bonusTo(po, aType, aName, aPC, po.getBonusList(aPC), aPC);
    }

    public static double equipBonusTo(Equipment po, String aType, String aName, PlayerCharacter aPC) {
        return BonusCalc.bonusTo(po, aType, aName, po, po.getBonusList(po), aPC);
    }

    private static double calcBonus(PObject po, String bString, String aType, String aName, String aTypePlusName, Object obj, int iTimes, BonusObj aBonusObj, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(bString, "|");
        if (aTok.countTokens() < 3) {
            Logging.errorPrint("Badly formed BONUS:" + bString);
            return 0.0;
        }
        String aString = aTok.nextToken();
        if (!aString.equalsIgnoreCase(aType) || aString.endsWith("%LIST") || aName.equals("ALL")) {
            return 0.0;
        }
        String aList = aTok.nextToken();
        if (!aList.equals("LIST") && !aList.equals("ALL") && aList.toUpperCase().indexOf(aName.toUpperCase()) < 0) {
            return 0.0;
        }
        if (aList.equals("ALL") && (aName.indexOf("STAT=") >= 0 || aName.indexOf("TYPE=") >= 0 || aName.indexOf("LIST") >= 0 || aName.indexOf("VAR") >= 0)) {
            return 0.0;
        }
        if (aTok.hasMoreTokens()) {
            aString = aTok.nextToken();
        }
        double iBonus = 0.0;
        if (obj instanceof PlayerCharacter) {
            iBonus = ((PlayerCharacter)obj).getVariableValue(aString, "").doubleValue();
        } else if (obj instanceof Equipment) {
            iBonus = ((Equipment)obj).getVariableValue(aString, "", aPC).doubleValue();
        } else {
            try {
                iBonus = Float.parseFloat(aString);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("calcBonus NumberFormatException in BONUS: " + aString, e);
            }
        }
        String possibleBonusTypeString = aBonusObj.getTypeString();
        if (obj instanceof PlayerCharacter ? !aBonusObj.qualifies((PlayerCharacter)obj, po) : !PrereqHandler.passesAll(aBonusObj.getPrerequisiteList(), (Equipment)obj, aPC)) {
            return 0.0;
        }
        double bonus = 0.0;
        String bonusTypeString = null;
        StringTokenizer bTok = new StringTokenizer(aList, ",");
        if (aList.equalsIgnoreCase("LIST")) {
            bTok.nextToken();
        } else if (aList.equalsIgnoreCase("ALL")) {
            aTypePlusName = aType + '.' + aName + '.';
            bonus = iBonus;
            bonusTypeString = possibleBonusTypeString;
        }
        while (bTok.hasMoreTokens()) {
            if (!bTok.nextToken().equalsIgnoreCase(aName)) continue;
            bonus += iBonus;
            bonusTypeString = possibleBonusTypeString;
        }
        if (obj instanceof Equipment) {
            ((Equipment)obj).setBonusStackFor(bonus * (double)iTimes, aTypePlusName + bonusTypeString);
        }
        if (aList.equals("ALL")) {
            return 0.0;
        }
        return bonus * (double)iTimes;
    }
}

