/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.util.Logging;

public final class BonusAddition {
    public static void applyBonus(String bonusString, String chooseString, PlayerCharacter aPC, CDOMObject target) {
        bonusString = BonusAddition.makeBonusString(bonusString, chooseString, aPC);
        BonusObj aBonus = Bonus.newBonus(Globals.getContext(), bonusString);
        if (aBonus != null) {
            aPC.addSaveableBonus(aBonus, target);
        }
    }

    public static void removeBonus(String bonusString, PlayerCharacter aPC, CDOMObject target) {
        BonusObj toRemove = null;
        BonusObj aBonus = Bonus.newBonus(Globals.getContext(), bonusString);
        String bonusStrRep = String.valueOf(aBonus);
        for (BonusObj bonusObj : aPC.getSaveableBonusList(target)) {
            if (!bonusObj.toString().equals(bonusStrRep)) continue;
            toRemove = bonusObj;
        }
        if (toRemove != null) {
            aPC.removeSaveableBonus(toRemove, target);
        } else {
            Logging.errorPrint("removeBonus: Could not find bonus: " + bonusString + " in bonusList " + aPC.getSaveableBonusList(target));
        }
    }

    private static String makeBonusString(String bonusString, String chooseString, PlayerCharacter aPC) {
        boolean lockIt;
        int i = chooseString.lastIndexOf(32);
        String classString = "";
        String levelString = "";
        if (bonusString.startsWith("BONUS:")) {
            bonusString = bonusString.substring(6);
        }
        if (lockIt = bonusString.endsWith(".LOCK")) {
            bonusString = bonusString.substring(0, bonusString.lastIndexOf(".LOCK"));
        }
        if (i >= 0) {
            classString = chooseString.substring(0, i);
            if (i < chooseString.length()) {
                levelString = chooseString.substring(i + 1);
            }
        }
        while (bonusString.lastIndexOf("TYPE=%") >= 0) {
            i = bonusString.lastIndexOf("TYPE=%");
            bonusString = bonusString.substring(0, i + 5) + classString + bonusString.substring(i + 6);
        }
        while (bonusString.lastIndexOf("CLASS=%") >= 0) {
            i = bonusString.lastIndexOf("CLASS=%");
            bonusString = bonusString.substring(0, i + 6) + classString + bonusString.substring(i + 7);
        }
        while (bonusString.lastIndexOf("LEVEL=%") >= 0) {
            i = bonusString.lastIndexOf("LEVEL=%");
            bonusString = bonusString.substring(0, i + 6) + levelString + bonusString.substring(i + 7);
        }
        if (lockIt) {
            i = bonusString.lastIndexOf(124);
            Float val = aPC.getVariableValue(bonusString.substring(i + 1), "");
            bonusString = bonusString.substring(0, i) + "|" + val;
        }
        return bonusString;
    }
}

