/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.NonInteractive;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Status;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SystemCollections;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.ConsolidatedListCommitStrategy;
import pcgen.rules.context.GameReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.RuntimeLoadContext;

public class Campaign
extends PObject
implements CampaignFacade,
NonInteractive {
    private ConsolidatedListCommitStrategy masterLCS = new ConsolidatedListCommitStrategy();
    private GameReferenceContext gameRefContext = new GameReferenceContext();
    private LoadContext context = new RuntimeLoadContext(this.gameRefContext, this.masterLCS);
    private DefaultListFacade<GameModeFacade> gameModes = null;

    public Campaign() {
        this.put(ObjectKey.SOURCE_CAMPAIGN, this);
    }

    public List<Campaign> getSubCampaigns() {
        List<CampaignSourceEntry> pccFiles = this.getSafeListFor(ListKey.FILE_PCC);
        ArrayList<Campaign> ret = new ArrayList<Campaign>(pccFiles.size());
        for (CampaignSourceEntry fileName : pccFiles) {
            Campaign campaign = Globals.getCampaignByURI(fileName.getURI(), true);
            if (campaign == null) continue;
            ret.add(campaign);
        }
        return ret;
    }

    public List<CampaignSourceEntry> getNotFoundSubCampaigns() {
        List<CampaignSourceEntry> pccFiles = this.getSafeListFor(ListKey.FILE_PCC);
        ArrayList<CampaignSourceEntry> ret = new ArrayList<CampaignSourceEntry>();
        for (CampaignSourceEntry cse : pccFiles) {
            Campaign campaign = Globals.getCampaignByURI(cse.getURI(), true);
            if (campaign != null) continue;
            ret.add(cse);
        }
        return ret;
    }

    public LoadContext getCampaignContext() {
        return this.context;
    }

    public void applyTo(AbstractReferenceContext rc) {
        for (ReferenceManufacturer<?> rm : this.gameRefContext.getAllManufacturers()) {
            GameMode.resolveReferenceManufacturer(rc, rm);
        }
    }

    @Override
    public boolean showInMenu() {
        return this.getSafe(ObjectKey.SHOW_IN_MENU);
    }

    @Override
    public ListFacade<GameModeFacade> getGameModes() {
        if (this.gameModes == null) {
            this.gameModes = new DefaultListFacade();
            List<String> modes = this.getSafeListFor(ListKey.GAME_MODE);
            for (String string : modes) {
                for (GameMode game : SystemCollections.getUnmodifiableGameModeList()) {
                    if (!game.getAllowedModes().contains(string)) continue;
                    this.gameModes.addElement(game);
                }
            }
        }
        return this.gameModes;
    }

    @Override
    public String getName() {
        return this.getKeyName();
    }

    @Override
    public String getPublisher() {
        return this.get(StringKey.DATA_PRODUCER);
    }

    @Override
    public String getFormat() {
        return this.get(StringKey.DATA_FORMAT);
    }

    @Override
    public String getSetting() {
        return this.get(StringKey.CAMPAIGN_SETTING);
    }

    @Override
    public String getSourceShort() {
        return this.get(StringKey.SOURCE_SHORT);
    }

    @Override
    public List<String> getBookTypeList() {
        return this.getSafeListFor(ListKey.BOOK_TYPE);
    }

    @Override
    public String getBookTypes() {
        return this.getListAsString(ListKey.BOOK_TYPE);
    }

    @Override
    public String getStatus() {
        Status status = this.getSafe(ObjectKey.STATUS);
        return status.toString();
    }
}

