/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.Arrays;
import java.util.Collection;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.TransparentReference;

public class CDOMTransparentTypeRef<T extends Loadable>
extends CDOMGroupRef<T>
implements TransparentReference<T> {
    private CDOMGroupRef<T> subReference = null;
    private final String[] types;

    public CDOMTransparentTypeRef(Class<T> objClass, String[] typeArray) {
        super(objClass, objClass.getSimpleName() + " " + Arrays.deepToString(typeArray));
        this.types = new String[typeArray.length];
        System.arraycopy(typeArray, 0, this.types, 0, typeArray.length);
    }

    @Override
    public boolean contains(T item) {
        if (this.subReference == null) {
            throw new IllegalStateException("Cannot ask for contains: " + this.getReferenceClass().getName() + " Reference " + this.getName() + " has not been resolved");
        }
        return this.subReference.contains(item);
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CDOMTransparentTypeRef) {
            CDOMTransparentTypeRef ref = (CDOMTransparentTypeRef)obj;
            return this.getReferenceClass().equals(ref.getReferenceClass()) && this.getName().equals(ref.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("Cannot resolve a Transparent Reference");
    }

    @Override
    public void resolve(ReferenceManufacturer<T> rm) {
        if (!rm.getReferenceClass().equals(this.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + rm.getReferenceClass().getSimpleName());
        }
        this.subReference = rm.getTypeReference(this.types);
    }

    @Override
    public Collection<T> getContainedObjects() {
        return this.subReference.getContainedObjects();
    }

    @Override
    public int getObjectCount() {
        return this.subReference == null ? 0 : this.subReference.getObjectCount();
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public String getChoice() {
        return this.subReference == null ? null : this.subReference.getChoice();
    }
}

