/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.Collections;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.QualifiedActor;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.util.Logging;

public final class SAProcessor
implements QualifiedActor<SpecialAbility, SpecialAbility> {
    private final PlayerCharacter pc;

    public SAProcessor(PlayerCharacter pc) {
        this.pc = pc;
    }

    @Override
    public SpecialAbility act(SpecialAbility sa, Object source) {
        String key = sa.getKeyName();
        int idx = key.indexOf("%CHOICE");
        if (idx == -1) {
            return sa;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(key.substring(0, idx));
        if (source instanceof ChooseDriver) {
            ChooseDriver object = (ChooseDriver)source;
            if (this.pc.hasAssociations(object)) {
                List<String> associationList = this.pc.getAssociationList(object);
                Collections.sort(associationList);
                sb.append((CharSequence)StringUtil.joinToStringBuilder(associationList, (String)", "));
            }
        } else {
            Logging.errorPrint("In SpecialAbility resolution, Error using object of type: " + source.getClass().getName() + " because " + "%CHOICE" + " was requested but the object does not support CHOOSE");
            sb.append("<undefined>");
        }
        sb.append(key.substring(idx + 7));
        return new SpecialAbility(sb.toString(), sa.getSADesc());
    }
}

