/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.helper.CNAbilitySelectionUtilities;

public class AbstractCNASEnforcingFacet
extends AbstractDataFacet<CharID, CNAbilitySelection>
implements DataFacetChangeListener<CharID, CNAbilitySelection> {
    public int size(CharID id) {
        List<List<SourcedCNAS>> list = this.getList(id);
        return list == null ? 0 : list.size();
    }

    public boolean isEmpty(CharID id) {
        List<List<SourcedCNAS>> list = this.getList(id);
        return list == null || list.isEmpty();
    }

    public boolean add(CharID id, CNAbilitySelection cnas, Object source) {
        if (cnas == null) {
            throw new IllegalArgumentException("Attempt to add null to list");
        }
        if (source == null) {
            throw new IllegalArgumentException("Attempt to add object with null source to list");
        }
        List<List<SourcedCNAS>> list = this.getConstructingList(id);
        for (List<SourcedCNAS> slist : list) {
            CNAbilitySelection main = slist.get((int)0).cnas;
            if (CNAbilitySelectionUtilities.canCoExist(main, cnas)) continue;
            slist.add(new SourcedCNAS(cnas, source));
            return false;
        }
        ArrayList<SourcedCNAS> newList = new ArrayList<SourcedCNAS>(1);
        newList.add(new SourcedCNAS(cnas, source));
        list.add(newList);
        this.fireDataFacetChangeEvent(id, cnas, 0);
        return true;
    }

    public boolean remove(CharID id, CNAbilitySelection cnas, Object source) {
        if (cnas == null) {
            throw new IllegalArgumentException("Attempt to remove null from list");
        }
        if (source == null) {
            throw new IllegalArgumentException("Attempt to remove object with null source from list");
        }
        List<List<SourcedCNAS>> list = this.getList(id);
        if (list == null) {
            return false;
        }
        Iterator<List<SourcedCNAS>> listIT = list.iterator();
        while (listIT.hasNext()) {
            List<SourcedCNAS> array = listIT.next();
            int length = array.size();
            for (int j = length - 1; j >= 0; --j) {
                SourcedCNAS sc = array.get(j);
                if (!cnas.equals(sc.cnas) || !source.equals(sc.source)) continue;
                if (j == 0 && length == 1) {
                    listIT.remove();
                    this.fireDataFacetChangeEvent(id, cnas, 1);
                    return true;
                }
                array.remove(j);
                CNAbilitySelection newPrimary = array.get((int)0).cnas;
                if (!cnas.equals(newPrimary) && j == 0) {
                    this.fireDataFacetChangeEvent(id, cnas, 1);
                    this.fireDataFacetChangeEvent(id, newPrimary, 0);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public Collection<CNAbilitySelection> getSet(CharID id) {
        List<List<SourcedCNAS>> list = this.getList(id);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<CNAbilitySelection> returnList = new ArrayList<CNAbilitySelection>();
        for (List<SourcedCNAS> array : list) {
            returnList.add(array.get((int)0).cnas);
        }
        return returnList;
    }

    protected List<List<SourcedCNAS>> getList(CharID id) {
        return (List)this.getCache(id);
    }

    private List<List<SourcedCNAS>> getConstructingList(CharID id) {
        List<List<SourcedCNAS>> list = this.getList(id);
        if (list == null) {
            list = new ArrayList<List<SourcedCNAS>>();
            this.setCache(id, list);
        }
        return list;
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        List<List<SourcedCNAS>> list = this.getList(source);
        if (list != null) {
            List<List<SourcedCNAS>> constructingList = this.getConstructingList(copy);
            for (List<SourcedCNAS> orig : list) {
                ArrayList<SourcedCNAS> newCnasList = new ArrayList<SourcedCNAS>(orig);
                constructingList.add(newCnasList);
            }
        }
    }

    public int getCount(CharID id) {
        List<List<SourcedCNAS>> list = this.getList(id);
        int count = 0;
        if (list != null) {
            for (List<SourcedCNAS> orig : list) {
                count += orig.size();
            }
        }
        return count;
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CNAbilitySelection> dfce) {
        this.add(dfce.getCharID(), dfce.getCDOMObject(), dfce.getSource());
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CNAbilitySelection> dfce) {
        this.remove(dfce.getCharID(), dfce.getCDOMObject(), dfce.getSource());
    }

    protected class SourcedCNAS {
        public final CNAbilitySelection cnas;
        public final Object source;

        public SourcedCNAS(CNAbilitySelection cnas, Object source) {
            this.cnas = cnas;
            this.source = source;
        }

        public String toString() {
            return this.cnas + " (src: " + this.source + ")";
        }

        public int hashCode() {
            return this.source.hashCode() ^ this.cnas.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SourcedCNAS) {
                SourcedCNAS other = (SourcedCNAS)o;
                return this.cnas.equals(other.cnas) && this.source.equals(other.source);
            }
            return false;
        }
    }
}

