/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.ConditionallyKnownSpellFacet;
import pcgen.cdom.facet.KnownSpellFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.AvailableSpell;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;

public class KnownSpellInputFacet
implements DataFacetChangeListener<CharID, CDOMObject> {
    private ConditionallyKnownSpellFacet conditionallyKnownSpellFacet;
    private KnownSpellFacet knownSpellFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        Collection<CDOMReference<CDOMList<?>>> listrefs = cdo.getModifiedLists();
        CharID id = dfce.getCharID();
        for (CDOMReference<? extends CDOMList<?>> cDOMReference : listrefs) {
            this.processListRef(id, cdo, cDOMReference);
        }
    }

    private void processListRef(CharID id, CDOMObject cdo, CDOMReference<? extends CDOMList<?>> listref) {
        for (CDOMList<Spell> cDOMList : listref.getContainedObjects()) {
            if (!(cDOMList instanceof ClassSpellList) && !(cDOMList instanceof DomainSpellList)) continue;
            CDOMList<Spell> spelllist = cDOMList;
            this.processList(id, spelllist, listref, cdo);
        }
    }

    private void processList(CharID id, CDOMList<Spell> spelllist, CDOMReference<? extends CDOMList<?>> listref, CDOMObject cdo) {
        for (CDOMReference objref : cdo.getListMods(listref)) {
            for (AssociatedPrereqObject apo : cdo.getListAssociations(listref, objref)) {
                Boolean known = apo.getAssociation(AssociationKey.KNOWN);
                if (known == null || !known.booleanValue()) continue;
                Collection spells = objref.getContainedObjects();
                Integer lvl = apo.getAssociation(AssociationKey.SPELL_LEVEL);
                if (apo.hasPrerequisites()) {
                    List<Prerequisite> prereqs = apo.getPrerequisiteList();
                    for (Spell spell : spells) {
                        AvailableSpell as = new AvailableSpell(spelllist, spell, lvl);
                        as.addAllPrerequisites(prereqs);
                        this.conditionallyKnownSpellFacet.add(id, as, cdo);
                    }
                    continue;
                }
                for (Spell spell : spells) {
                    this.knownSpellFacet.add(id, spelllist, lvl, spell, cdo);
                }
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject source = dfce.getCDOMObject();
        this.conditionallyKnownSpellFacet.removeAll(id, source);
        this.knownSpellFacet.removeAllFromSource(id, source);
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void setConditionallyKnownSpellFacet(ConditionallyKnownSpellFacet conditionallyKnownSpellFacet) {
        this.conditionallyKnownSpellFacet = conditionallyKnownSpellFacet;
    }

    public void setKnownSpellFacet(KnownSpellFacet knownSpellFacet) {
        this.knownSpellFacet = knownSpellFacet;
    }
}

