/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import pcgen.cdom.base.CDOMList;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.DomainFacet;
import pcgen.cdom.helper.ClassSource;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.spell.Spell;

public class DomainSpellsFacet
extends AbstractSourcedListFacet<CharID, CDOMList<Spell>>
implements DataFacetChangeListener<CharID, Domain> {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private DomainFacet domainFacet;
    private ClassFacet classFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Domain> dfce) {
        String classKey;
        PCClass domainClass;
        Domain domain = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        ClassSource source = (ClassSource)this.domainFacet.getSource(id, domain);
        if (source != null && (domainClass = this.getClassKeyed(id, classKey = source.getPcclass().getKeyName())) != null) {
            PlayerCharacter pc = this.trackingFacet.getPC(id);
            int maxLevel = pc.getSpellSupport(domainClass).getMaxCastLevel();
            DomainApplication.addSpellsToClassForLevels(pc, domain, domainClass, 0, maxLevel);
        }
    }

    private PCClass getClassKeyed(CharID id, String classKey) {
        for (PCClass aClass : this.classFacet.getSet(id)) {
            if (!aClass.getKeyName().equalsIgnoreCase(classKey)) continue;
            return aClass;
        }
        return null;
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Domain> dfce) {
    }

    public void setDomainFacet(DomainFacet domainFacet) {
        this.domainFacet = domainFacet;
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void init() {
        this.domainFacet.addDataFacetChangeListener(this);
    }
}

