/*
 * Decompiled with CFR 0.152.
 */
package gmgen.util;

import gmgen.util.LogReceiver;
import java.util.ArrayList;
import java.util.List;

public class LogUtilities
implements LogReceiver {
    private static LogUtilities singleton = null;
    private List<LogReceiver> receivers = new ArrayList<LogReceiver>();
    private boolean logging = false;

    private LogUtilities() {
    }

    public static LogUtilities inst() {
        if (singleton == null) {
            singleton = new LogUtilities();
        }
        return singleton;
    }

    public void setLogging(boolean loggingFlag) {
        this.logging = loggingFlag;
    }

    public void addReceiver(LogReceiver receiver) {
        this.receivers.add(receiver);
    }

    @Override
    public void logMessage(String owner, String message) {
        if (this.logging) {
            for (LogReceiver rcvr : this.receivers) {
                rcvr.logMessage(owner, message);
            }
        }
    }

    @Override
    public void logMessage(String message) {
        if (this.logging) {
            for (LogReceiver rcvr : this.receivers) {
                rcvr.logMessage(message);
            }
        }
    }
}

