/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.math;

import pcgen.base.lang.NumberUtilities;

public class OrderedPair {
    private Number x;
    private Number y;

    public OrderedPair(Number x, Number y) {
        if (x == null) {
            throw new IllegalArgumentException("x value cannot be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("x value cannot be null");
        }
        this.x = x;
        this.y = y;
    }

    public Number getPreciseX() {
        return this.x;
    }

    public Number getPreciseY() {
        return this.y;
    }

    public static OrderedPair valueOf(String value) {
        Number height;
        Number width;
        int commaLoc = value.indexOf(44);
        if (commaLoc != value.lastIndexOf(44)) {
            throw new IllegalArgumentException("OrderedPair must have only one comma.  Must be of the form: <num>,<num>");
        }
        if (commaLoc == -1) {
            throw new IllegalArgumentException("OrderedPair must have a comma.  Must be of the form: <num>,<num>");
        }
        if (commaLoc == 0) {
            throw new IllegalArgumentException("OrderedPair should not start with a comma.  Must be of the form: <num>,<num>");
        }
        if (commaLoc == value.length() - 1) {
            throw new IllegalArgumentException("OrderedPair should not end with a comma.  Must be of the form: <num>,<num>");
        }
        try {
            String widthString = value.substring(0, commaLoc).trim();
            width = NumberUtilities.getPreciseNumber(widthString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Misunderstood first value in OrderedPair: " + value);
        }
        try {
            String heightString = value.substring(commaLoc + 1).trim();
            height = NumberUtilities.getPreciseNumber(heightString);
        }
        catch (NumberFormatException ne) {
            throw new IllegalArgumentException("Misunderstood second value in OrderedPair: " + value);
        }
        return new OrderedPair(width, height);
    }

    public String toString() {
        return this.x.toString() + "," + this.y.toString();
    }

    public int hashCode() {
        return this.x.hashCode() ^ this.y.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrderedPair) {
            OrderedPair other = (OrderedPair)o;
            return other.x.equals(this.x) && other.y.equals(this.y);
        }
        return false;
    }
}

