/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.InputStream;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.InputProgressEvent;

public class MonitoredInputStream
extends InputStream {
    private final InputStream delegate;
    private int progress = 0;
    private final long minProgressEventGap;
    public final EventDispatch evtProgress = new EventDispatch();
    private long lastEvenPosted = 0L;

    public MonitoredInputStream(InputStream delegate, int minProgressEventGap) {
        this.delegate = delegate;
        this.minProgressEventGap = minProgressEventGap;
    }

    public MonitoredInputStream(InputStream delegate) {
        this(delegate, 200);
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int b = this.delegate.read();
        if (b != -1) {
            ++this.progress;
        }
        return b;
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int numRead = this.delegate.read(arg0, arg1, arg2);
        if (numRead != -1) {
            this.progress += numRead;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastEvenPosted > this.minProgressEventGap) {
                this.evtProgress.fireEvent(new InputProgressEvent(this, this.progress));
                this.lastEvenPosted = currentTime;
            }
        }
        return numRead;
    }
}

