/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.ObjectContainer;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.core.Deity;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreDeityTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int runningTotal;
        if (prereq.getKey().startsWith("PANTHEON.")) {
            try {
                String pantheon = prereq.getKey().substring(9);
                Deity deity = display.getDeity();
                WrappedMapSet charDeityPantheon = new WrappedMapSet(CaseInsensitiveMap.class);
                if (deity != null) {
                    FactSetKey fk = FactSetKey.valueOf((String)"Pantheon");
                    for (ObjectContainer oc : deity.getSafeSetFor(fk)) {
                        charDeityPantheon.addAll(oc.getContainedObjects());
                    }
                }
                if (prereq.getOperator().equals((Object)PrerequisiteOperator.EQ) || prereq.getOperator().equals((Object)PrerequisiteOperator.GTEQ)) {
                    runningTotal = charDeityPantheon.contains(pantheon) ? 1 : 0;
                }
                if (prereq.getOperator().equals((Object)PrerequisiteOperator.NEQ) || prereq.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                    runningTotal = charDeityPantheon.contains(pantheon) ? 0 : 1;
                }
                throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreDeity.error.bad_coparator", (Object[])new Object[]{prereq.toString()}));
            }
            catch (IllegalArgumentException e) {
                if (prereq.getOperator().equals((Object)PrerequisiteOperator.EQ) || prereq.getOperator().equals((Object)PrerequisiteOperator.GTEQ)) {
                    runningTotal = 0;
                }
                if (prereq.getOperator().equals((Object)PrerequisiteOperator.NEQ) || prereq.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                    runningTotal = 1;
                }
                throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreDeity.error.bad_coparator", (Object[])new Object[]{prereq.toString()}));
            }
        } else {
            String charDeity;
            String string = charDeity = display.getDeity() != null ? display.getDeity().getKeyName() : "";
            if (prereq.getOperator().equals((Object)PrerequisiteOperator.EQ) || prereq.getOperator().equals((Object)PrerequisiteOperator.GTEQ)) {
                runningTotal = charDeity.equalsIgnoreCase(prereq.getKey()) ? 1 : 0;
            } else if (prereq.getOperator().equals((Object)PrerequisiteOperator.NEQ) || prereq.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                runningTotal = charDeity.equalsIgnoreCase(prereq.getKey()) ? 0 : 1;
            } else {
                throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreDeity.error.bad_coparator", (Object[])new Object[]{prereq.toString()}));
            }
        }
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "DEITY";
    }
}

