/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.layout;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.layout.BoundedSize;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.Size;
import com.jgoodies.layout.layout.Unit;
import com.jgoodies.layout.util.DefaultUnitConverter;
import com.jgoodies.layout.util.UnitConverter;
import java.awt.Component;
import java.util.Locale;

public final class Sizes {
    public static final ConstantSize ZERO = Sizes.pixel(0);
    public static final ConstantSize DLU1 = Sizes.constant("1dlu");
    public static final ConstantSize DLU2 = Sizes.constant("2dlu");
    public static final ConstantSize DLU3 = Sizes.constant("3dlu");
    public static final ConstantSize DLU4 = Sizes.constant("4dlu");
    public static final ConstantSize DLU5 = Sizes.constant("5dlu");
    public static final ConstantSize DLU6 = Sizes.constant("6dlu");
    public static final ConstantSize DLU7 = Sizes.constant("7dlu");
    public static final ConstantSize DLU8 = Sizes.constant("8dlu");
    public static final ConstantSize DLU9 = Sizes.constant("9dlu");
    public static final ConstantSize DLU11 = Sizes.constant("11dlu");
    public static final ConstantSize DLU14 = Sizes.constant("14dlu");
    public static final ConstantSize DLU21 = Sizes.constant("21dlu");
    public static final ConstantSize EPX4 = Sizes.constant("4epx");
    public static final ConstantSize EPX8 = Sizes.constant("8epx");
    public static final ConstantSize EPX12 = Sizes.constant("12epx");
    public static final ConstantSize EPX16 = Sizes.constant("16epx");
    public static final ConstantSize EPX24 = Sizes.constant("24epx");
    public static final ConstantSize EPX48 = Sizes.constant("48epx");
    private static UnitConverter unitConverter;
    private static Unit defaultUnit;

    private Sizes() {
    }

    public static ConstantSize constant(String encodedValueAndUnit) {
        String lowerCase = encodedValueAndUnit.toLowerCase(Locale.ENGLISH);
        String trimmed = lowerCase.trim();
        return ConstantSize.decode(trimmed);
    }

    public static ConstantSize dlu(int value) {
        return new ConstantSize(value, Unit.DIALOG_UNITS);
    }

    public static ConstantSize pixel(int value) {
        return new ConstantSize(value, Unit.PIXEL);
    }

    public static ConstantSize effectivePixel(int value) {
        return Sizes.epx(value);
    }

    public static ConstantSize epx(int value) {
        return new ConstantSize(value, Unit.EFFECTIVE_PIXEL);
    }

    public static Size bounded(Size basis, Size lowerBound, Size upperBound) {
        return new BoundedSize(basis, lowerBound, upperBound);
    }

    public static int inchAsPixel(double in, Component component) {
        return in == 0.0 ? 0 : Sizes.getUnitConverter().inchAsPixel(in, component);
    }

    public static int millimeterAsPixel(double mm, Component component) {
        return mm == 0.0 ? 0 : Sizes.getUnitConverter().millimeterAsPixel(mm, component);
    }

    public static int centimeterAsPixel(double cm, Component component) {
        return cm == 0.0 ? 0 : Sizes.getUnitConverter().centimeterAsPixel(cm, component);
    }

    public static int pointAsPixel(int pt, Component component) {
        return pt == 0 ? 0 : Sizes.getUnitConverter().pointAsPixel(pt, component);
    }

    public static int dialogUnitXAsPixel(int dluX, Component component) {
        return dluX == 0 ? 0 : Sizes.getUnitConverter().dialogUnitXAsPixel(dluX, component);
    }

    public static int dialogUnitYAsPixel(int dluY, Component component) {
        return dluY == 0 ? 0 : Sizes.getUnitConverter().dialogUnitYAsPixel(dluY, component);
    }

    public static UnitConverter getUnitConverter() {
        if (unitConverter == null) {
            unitConverter = DefaultUnitConverter.getInstance();
        }
        return unitConverter;
    }

    public static void setUnitConverter(UnitConverter newUnitConverter) {
        unitConverter = newUnitConverter;
    }

    public static Unit getDefaultUnit() {
        return defaultUnit;
    }

    public static void setDefaultUnit(Unit unit) {
        defaultUnit = Preconditions.checkNotNull(unit, "The %s must not be null.", "default unit");
    }

    static {
        defaultUnit = Unit.PIXEL;
    }
}

