/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.layout;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.layout.BoundedSize;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.ComponentSize;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.PrototypeSize;
import com.jgoodies.layout.layout.RowSpec;
import com.jgoodies.layout.layout.Size;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class FormSpec
implements Serializable {
    static final DefaultAlignment LEFT_ALIGN = new DefaultAlignment("left");
    static final DefaultAlignment RIGHT_ALIGN = new DefaultAlignment("right");
    static final DefaultAlignment TOP_ALIGN = new DefaultAlignment("top");
    static final DefaultAlignment BOTTOM_ALIGN = new DefaultAlignment("bottom");
    static final DefaultAlignment CENTER_ALIGN = new DefaultAlignment("center");
    static final DefaultAlignment FILL_ALIGN = new DefaultAlignment("fill");
    static final DefaultAlignment NO_ALIGN = new DefaultAlignment("none");
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN, NO_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private static final Pattern TOKEN_SEPARATOR_PATTERN = Pattern.compile(":");
    private static final Pattern BOUNDS_SEPARATOR_PATTERN = Pattern.compile("\\s*,\\s*");
    private DefaultAlignment defaultAlignment;
    private boolean defaultAlignmentExplicitlySet;
    private Size size;
    private double resizeWeight;

    protected FormSpec(DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        Preconditions.checkNotNull(size, "The %s must not be null.", "size");
        Preconditions.checkArgument(resizeWeight >= 0.0, "The resize weight must be non-negative.");
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = resizeWeight;
    }

    protected FormSpec(DefaultAlignment defaultAlignment, String encodedDescription) {
        this(defaultAlignment, ComponentSize.DEFAULT, 0.0);
        this.parseAndInitValues(encodedDescription.toLowerCase(Locale.ENGLISH));
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final boolean getDefaultAlignmentExplictlySet() {
        return this.defaultAlignmentExplicitlySet;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    abstract boolean isHorizontal();

    void setDefaultAlignment(DefaultAlignment defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
        this.defaultAlignmentExplicitlySet = true;
    }

    void setSize(Size size) {
        this.size = size;
    }

    void setResizeWeight(double resizeWeight) {
        this.resizeWeight = resizeWeight;
    }

    private void parseAndInitValues(String encodedDescription) {
        Preconditions.checkNotBlank(encodedDescription, "The %s must not be null, empty, or whitespace.", "encoded form specification");
        String[] token = TOKEN_SEPARATOR_PATTERN.split(encodedDescription);
        Preconditions.checkArgument(token.length > 0, "The form spec must not be empty.");
        int nextIndex = 0;
        String next = token[nextIndex++];
        DefaultAlignment alignment = DefaultAlignment.valueOf(next, this.isHorizontal());
        if (alignment != null) {
            this.setDefaultAlignment(alignment);
            Preconditions.checkArgument(token.length > 1, "The form spec must provide a size.");
            next = token[nextIndex++];
        }
        this.setSize(FormSpec.parseSize(next));
        if (nextIndex < token.length) {
            this.setResizeWeight(FormSpec.parseResizeWeight(token[nextIndex]));
        }
    }

    private static Size parseSize(String token) {
        if (token.startsWith("[") && token.endsWith("]")) {
            return FormSpec.parseBoundedSize(token);
        }
        if (token.startsWith("max(") && token.endsWith(")")) {
            return FormSpec.parseOldBoundedSize(token, false);
        }
        if (token.startsWith("min(") && token.endsWith(")")) {
            return FormSpec.parseOldBoundedSize(token, true);
        }
        return FormSpec.parseAtomicSize(token);
    }

    private static Size parseBoundedSize(String token) {
        String content = token.substring(1, token.length() - 1);
        String[] subtoken = BOUNDS_SEPARATOR_PATTERN.split(content);
        Size basis = null;
        Size lower = null;
        Size upper = null;
        if (subtoken.length == 2) {
            Size size1 = FormSpec.parseAtomicSize(subtoken[0]);
            Size size2 = FormSpec.parseAtomicSize(subtoken[1]);
            if (FormSpec.isConstant(size1)) {
                if (FormSpec.isConstant(size2)) {
                    lower = size1;
                    basis = size2;
                    upper = size2;
                } else {
                    lower = size1;
                    basis = size2;
                }
            } else {
                basis = size1;
                upper = size2;
            }
        } else if (subtoken.length == 3) {
            lower = FormSpec.parseAtomicSize(subtoken[0]);
            basis = FormSpec.parseAtomicSize(subtoken[1]);
            upper = FormSpec.parseAtomicSize(subtoken[2]);
        }
        if ((lower == null || FormSpec.isConstant(lower)) && (upper == null || FormSpec.isConstant(upper))) {
            return new BoundedSize(basis, lower, upper);
        }
        throw new IllegalArgumentException("Illegal bounded size '" + token + "'. Must be one of:\n[<constant size>,<logical size>]                 // lower bound\n[<logical size>,<constant size>]                 // upper bound\n[<constant size>,<logical size>,<constant size>] // lower and upper bound.\nExamples:\n[50dlu,pref]                                     // lower bound\n[pref,200dlu]                                    // upper bound\n[50dlu,pref,200dlu]                              // lower and upper bound.");
    }

    private static Size parseOldBoundedSize(String token, boolean setMax) {
        int semicolonIndex = token.indexOf(59);
        String sizeToken1 = token.substring(4, semicolonIndex);
        String sizeToken2 = token.substring(semicolonIndex + 1, token.length() - 1);
        Size size1 = FormSpec.parseAtomicSize(sizeToken1);
        Size size2 = FormSpec.parseAtomicSize(sizeToken2);
        if (FormSpec.isConstant(size1)) {
            if (size2 instanceof ComponentSize) {
                return new BoundedSize(size2, setMax ? null : size1, setMax ? size1 : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (FormSpec.isConstant(size2)) {
            return new BoundedSize(size1, setMax ? null : size2, setMax ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private static Size parseAtomicSize(String token) {
        String trimmedToken = token.trim();
        if (trimmedToken.startsWith("'") && trimmedToken.endsWith("'")) {
            int length = trimmedToken.length();
            if (length < 2) {
                throw new IllegalArgumentException("Missing closing \"'\" for prototype.");
            }
            return new PrototypeSize(trimmedToken.substring(1, length - 1));
        }
        ComponentSize componentSize = ComponentSize.decode(trimmedToken);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.decode(trimmedToken);
    }

    private static double parseResizeWeight(String token) {
        if (token.equals("g") || token.equals("grow")) {
            return 1.0;
        }
        if (token.equals("n") || token.equals("nogrow") || token.equals("none")) {
            return 0.0;
        }
        if ((token.startsWith("grow(") || token.startsWith("g(")) && token.endsWith(")")) {
            int leftParen = token.indexOf(40);
            int rightParen = token.indexOf(41);
            String substring = token.substring(leftParen + 1, rightParen);
            return Double.parseDouble(substring);
        }
        throw new IllegalArgumentException("The resize argument '" + token + "' is invalid.  Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    private static boolean isConstant(Size aSize) {
        return aSize instanceof ConstantSize || aSize instanceof PrototypeSize;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder().append(this.defaultAlignment).append(":").append(this.size.toString()).append(':');
        if (this.resizeWeight == 0.0) {
            builder.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            builder.append("grow");
        } else {
            builder.append("grow(").append(this.resizeWeight).append(')');
        }
        return builder.toString();
    }

    public final String toShortString() {
        StringBuilder builder = new StringBuilder().append(this.defaultAlignment.abbreviation()).append(":").append(this.size.toString()).append(':');
        if (this.resizeWeight == 0.0) {
            builder.append("n");
        } else if (this.resizeWeight == 1.0) {
            builder.append("g");
        } else {
            builder.append("g(").append(this.resizeWeight).append(')');
        }
        return builder.toString();
    }

    public final String encode() {
        DefaultAlignment alignmentDefault;
        StringBuilder builder = new StringBuilder();
        DefaultAlignment defaultAlignment = alignmentDefault = this.isHorizontal() ? ColumnSpec.DEFAULT : RowSpec.DEFAULT;
        if (!alignmentDefault.equals(this.defaultAlignment)) {
            builder.append(this.defaultAlignment.abbreviation()).append(":");
        }
        builder.append(this.size.encode());
        if (this.resizeWeight != 0.0) {
            if (this.resizeWeight == 1.0) {
                builder.append(':').append("g");
            } else {
                builder.append(':').append("g(").append(this.resizeWeight).append(')');
            }
        }
        return builder.toString();
    }

    final int maximumSize(Container container, List<Component> components, FormLayout.ComponentSizeCache sizeCache, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure, boolean horizontal) {
        return this.size.maximumSize(container, components, sizeCache, minMeasure, prefMeasure, defaultMeasure, horizontal);
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private DefaultAlignment(String name) {
            this.name = name;
        }

        private static DefaultAlignment valueOf(String str, boolean isHorizontal) {
            if (str.equals("f") || str.equals("fill")) {
                return FILL_ALIGN;
            }
            if (str.equals("c") || str.equals("center")) {
                return CENTER_ALIGN;
            }
            if (isHorizontal) {
                if (str.equals("r") || str.equals("right")) {
                    return RIGHT_ALIGN;
                }
                if (str.equals("l") || str.equals("left")) {
                    return LEFT_ALIGN;
                }
                if (str.equals("none")) {
                    return NO_ALIGN;
                }
                return null;
            }
            if (str.equals("t") || str.equals("top")) {
                return TOP_ALIGN;
            }
            if (str.equals("b") || str.equals("bottom")) {
                return BOTTOM_ALIGN;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

