/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.rundeck.client.api.model.ErrorDetail;
import org.rundeck.client.util.Xml;

@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@Xml
public class ErrorResponse
implements ErrorDetail {
    @XmlAttribute(name="error")
    @JsonProperty(value="error")
    public String errorString;
    @JsonProperty(value="message")
    public String messageString;
    @JsonProperty(value="messages")
    public List<String> messages;
    @JsonProperty(value="errorCode")
    public String errorCodeJson;
    @XmlAttribute
    public int apiversion;
    @XmlElement
    Error error;

    @Override
    public String getErrorCode() {
        return null != this.error ? this.error.code : this.errorCodeJson;
    }

    @Override
    public String toCodeString() {
        if (null != this.getErrorCode()) {
            return String.format("[code: %s; APIv%d]", this.getErrorCode(), this.apiversion);
        }
        return "";
    }

    @Override
    public String getErrorMessage() {
        return this.error != null ? this.error.getSingleMessage() : (null != this.messages ? this.messages.toString() : this.messageString);
    }

    @Override
    public int getApiVersion() {
        return this.apiversion;
    }

    public String toString() {
        return String.format("%s%n%s", this.getErrorMessage() != null ? this.getErrorMessage() : "(no message)", this.toCodeString());
    }

    static class Error {
        @XmlAttribute
        String code;
        @XmlElement(name="message")
        String messageString;
        @XmlElementWrapper(name="messages")
        @XmlElement(name="message")
        public List<Message> messageList;
        @XmlElement(name="message")
        public Message message;

        Error() {
        }

        String getSingleMessage() {
            if (null != this.messageList) {
                if (this.messageList.size() == 1) {
                    return this.messageList.get((int)0).message;
                }
                return this.messageList.toString();
            }
            if (null != this.message) {
                return this.message.message;
            }
            return this.messageString;
        }

        static class Message {
            @XmlValue
            String message;

            Message() {
            }

            public String toString() {
                return this.message;
            }
        }
    }
}

