/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.Set;
import org.apache.tools.ant.taskdefs.Chmod;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.plugins.DefaultJavaAppStartScriptGenerationDetails;
import org.gradle.api.internal.plugins.UnixStartScriptGenerator;
import org.gradle.api.internal.plugins.WindowsStartScriptGenerator;
import org.gradle.internal.IoActions;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.application.scripts.JavaAppStartScriptGenerationDetails;
import org.gradle.jvm.application.scripts.ScriptGenerator;
import org.gradle.util.internal.AntUtil;
import org.gradle.util.internal.CollectionUtils;

public class StartScriptGenerator {
    private String applicationName;
    private String optsEnvironmentVar;
    private String exitEnvironmentVar;
    private String mainClassName;
    private Iterable<String> defaultJvmOpts = Collections.emptyList();
    private Iterable<String> classpath;
    private Iterable<String> modulePath = Collections.emptyList();
    private String scriptRelPath;
    private String appNameSystemProperty;
    private final ScriptGenerator unixStartScriptGenerator;
    private final ScriptGenerator windowsStartScriptGenerator;
    private final UnixFileOperation unixFileOperation;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setOptsEnvironmentVar(String optsEnvironmentVar) {
        this.optsEnvironmentVar = optsEnvironmentVar;
    }

    public void setExitEnvironmentVar(String exitEnvironmentVar) {
        this.exitEnvironmentVar = exitEnvironmentVar;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void setDefaultJvmOpts(Iterable<String> defaultJvmOpts) {
        this.defaultJvmOpts = defaultJvmOpts;
    }

    public void setClasspath(Iterable<String> classpath) {
        this.classpath = classpath;
    }

    public void setModulePath(Iterable<String> modulePath) {
        this.modulePath = modulePath;
    }

    public void setScriptRelPath(String scriptRelPath) {
        this.scriptRelPath = scriptRelPath;
    }

    public void setAppNameSystemProperty(String appNameSystemProperty) {
        this.appNameSystemProperty = appNameSystemProperty;
    }

    public StartScriptGenerator() {
        this(new UnixStartScriptGenerator(), new WindowsStartScriptGenerator());
    }

    public StartScriptGenerator(ScriptGenerator unixStartScriptGenerator, ScriptGenerator windowsStartScriptGenerator) {
        this(unixStartScriptGenerator, windowsStartScriptGenerator, new DefaultUnixFileOperation());
    }

    StartScriptGenerator(ScriptGenerator unixStartScriptGenerator, ScriptGenerator windowsStartScriptGenerator, UnixFileOperation unixFileOperation) {
        this.unixStartScriptGenerator = unixStartScriptGenerator;
        this.windowsStartScriptGenerator = windowsStartScriptGenerator;
        this.unixFileOperation = unixFileOperation;
    }

    private JavaAppStartScriptGenerationDetails createStartScriptGenerationDetails() {
        return new DefaultJavaAppStartScriptGenerationDetails(this.applicationName, this.optsEnvironmentVar, this.exitEnvironmentVar, this.mainClassName, CollectionUtils.toStringList(this.defaultJvmOpts), CollectionUtils.toStringList(this.classpath), CollectionUtils.toStringList(this.modulePath), this.scriptRelPath, this.appNameSystemProperty);
    }

    public void generateUnixScript(File unixScript) {
        IoActions.writeTextFile((File)unixScript, (String)StandardCharsets.UTF_8.name(), (Action)new Generate(this.createStartScriptGenerationDetails(), this.unixStartScriptGenerator));
        this.unixFileOperation.createExecutablePermission(unixScript);
    }

    public void generateWindowsScript(File windowsScript) {
        IoActions.writeTextFile((File)windowsScript, (String)StandardCharsets.UTF_8.name(), (Action)new Generate(this.createStartScriptGenerationDetails(), this.windowsStartScriptGenerator));
    }

    private static final class DefaultUnixFileOperation
    implements UnixFileOperation {
        private DefaultUnixFileOperation() {
        }

        @Override
        public void createExecutablePermission(File file) {
            if (OperatingSystem.current().isWindows()) {
                this.createWindowsExecutablePermission(file);
            } else {
                this.createPosixExecutablePermission(file);
            }
        }

        private void createWindowsExecutablePermission(File file) {
            Chmod chmod = new Chmod();
            chmod.setFile(file);
            chmod.setPerm("ugo+rx");
            chmod.setProject(AntUtil.createProject());
            chmod.execute();
        }

        private void createPosixExecutablePermission(File file) {
            Path path = file.toPath();
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                permissions.add(PosixFilePermission.OWNER_READ);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                permissions.add(PosixFilePermission.GROUP_READ);
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
                permissions.add(PosixFilePermission.OTHERS_READ);
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(path, permissions);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    static interface UnixFileOperation {
        public void createExecutablePermission(File var1);
    }

    private static class Generate
    implements Action<BufferedWriter> {
        private final JavaAppStartScriptGenerationDetails startScriptGenerationDetails;
        private final ScriptGenerator unixStartScriptGenerator;

        public Generate(JavaAppStartScriptGenerationDetails startScriptGenerationDetails, ScriptGenerator unixStartScriptGenerator) {
            this.startScriptGenerationDetails = startScriptGenerationDetails;
            this.unixStartScriptGenerator = unixStartScriptGenerator;
        }

        public void execute(BufferedWriter writer) {
            this.unixStartScriptGenerator.generateScript(this.startScriptGenerationDetails, writer);
        }
    }
}

