/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.declarative.dsl.schema.DataClass;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.SchemaFunction;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.analysis.TypeRefContext;
import org.gradle.internal.declarativedsl.language.DataTypeInternal;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a \u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0000\u001a3\u0010\u0016\u001a\u00020\t*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0080\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"checkIsAssignable", "", "valueType", "Lorg/gradle/declarative/dsl/schema/DataType;", "isAssignableTo", "sameType", "left", "right", "checkAccessOnCurrentReceiver", "", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "receiver", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "access", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "format", "", "Lorg/gradle/declarative/dsl/schema/SchemaFunction;", "lowercase", "getDataType", "Lorg/gradle/internal/declarativedsl/analysis/TypeRefContext;", "objectOrigin", "withScope", "scope", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisScope;", "action", "Lkotlin/Function0;", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/gradle/internal/declarativedsl/analysis/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withScope(@NotNull AnalysisContext $this$withScope, @NotNull AnalysisScope scope, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withScope = false;
        $this$withScope.enterScope(scope);
        try {
            action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withScope.leaveScope(scope);
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final boolean checkIsAssignable(@NotNull DataType valueType, @NotNull DataType isAssignableTo) {
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)isAssignableTo, (String)"isAssignableTo");
        return isAssignableTo instanceof DataClass ? valueType instanceof DataClass && (UtilsKt.sameType(valueType, isAssignableTo) || ((DataClass)valueType).getSupertypes().contains(((DataClass)isAssignableTo).getName())) : UtilsKt.sameType(valueType, isAssignableTo);
    }

    public static final boolean sameType(@NotNull DataType left, @NotNull DataType right) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        DataType dataType = left;
        if (dataType instanceof DataType.ClassDataType) {
            bl = right instanceof DataType.ClassDataType && Intrinsics.areEqual((Object)((DataType.ClassDataType)left).getName().getQualifiedName(), (Object)((DataType.ClassDataType)right).getName().getQualifiedName());
        } else if (dataType instanceof DataType.BooleanDataType) {
            bl = right instanceof DataType.BooleanDataType;
        } else if (dataType instanceof DataType.IntDataType) {
            bl = right instanceof DataType.IntDataType;
        } else if (dataType instanceof DataType.LongDataType) {
            bl = right instanceof DataType.LongDataType;
        } else if (dataType instanceof DataType.StringDataType) {
            bl = right instanceof DataType.StringDataType;
        } else if (dataType instanceof DataType.NullType) {
            bl = right instanceof DataType.NullType;
        } else if (dataType instanceof DataType.UnitType) {
            bl = right instanceof DataType.UnitType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public static final DataType getDataType(@NotNull TypeRefContext $this$getDataType, @NotNull ObjectOrigin objectOrigin) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)$this$getDataType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectOrigin, (String)"objectOrigin");
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin) {
            dataType = UtilsKt.getDataType($this$getDataType, ((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
            dataType = (DataType)((ObjectOrigin.ConstantOrigin)objectOrigin).getLiteral().getType();
        } else if (objectOrigin2 instanceof ObjectOrigin.EnumConstantOrigin) {
            dataType = (DataType)((ObjectOrigin.EnumConstantOrigin)objectOrigin).getType();
        } else if (objectOrigin2 instanceof ObjectOrigin.External) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.External)objectOrigin).getKey().getObjectType());
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromMemberFunction) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.NewObjectFromMemberFunction)objectOrigin).getFunction().getReturnValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromTopLevelFunction) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.NewObjectFromTopLevelFunction)objectOrigin).getFunction().getReturnValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.PropertyReference)objectOrigin).getProperty().getValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.PropertyDefaultValue)objectOrigin).getProperty().getValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
            dataType = ((ObjectOrigin.TopLevelReceiver)objectOrigin).getType();
        } else if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
            dataType = (DataType)DataTypeInternal.DefaultNullType.INSTANCE;
        } else if (objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.CustomConfigureAccessor)objectOrigin).getAccessedType());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConfiguringLambdaReceiver) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.ConfiguringLambdaReceiver)objectOrigin).getLambdaReceiverType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataType;
    }

    public static final void checkAccessOnCurrentReceiver(@NotNull AnalysisContext $this$checkAccessOnCurrentReceiver, @NotNull ObjectOrigin receiver, @NotNull LanguageTreeElement access) {
        Intrinsics.checkNotNullParameter((Object)$this$checkAccessOnCurrentReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (!(receiver instanceof ObjectOrigin.ImplicitThisReceiver) || !((ObjectOrigin.ImplicitThisReceiver)receiver).isCurrentScopeReceiver()) {
            $this$checkAccessOnCurrentReceiver.getErrorCollector().collect(new ResolutionError(access, ErrorReason.AccessOnCurrentReceiverOnlyViolation.INSTANCE));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String format(@NotNull SchemaFunction $this$format, @Nullable ObjectOrigin receiver, boolean lowercase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String text = receiver == null ? "top level function " + $this$format.getSimpleName() : "function " + $this$format.getSimpleName() + " (having as receiver " + receiver + ')';
        if (!lowercase) {
            String string2 = text;
            if (((CharSequence)string2).length() > 0) {
                void it;
                char c = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string3 = String.valueOf((char)it);
                Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                String string4 = string3.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                String string5 = string2;
                int n = 1;
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                string = stringBuilder2.append(string6).toString();
            } else {
                string = string2;
            }
        } else {
            string = text;
        }
        return string;
    }

    public static /* synthetic */ String format$default(SchemaFunction schemaFunction, ObjectOrigin objectOrigin, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UtilsKt.format(schemaFunction, objectOrigin, bl);
    }
}

