/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import javax.swing.JFileChooser;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.util.EditableListFileEditor;
import net.charabia.jsmoothgen.application.gui.util.GenericFileFilter;
import net.charabia.jsmoothgen.application.gui.util.SortedEditableList;

public class ClassPath
extends Editor {
    private JFileChooser m_jarLocFileChooser = new JFileChooser();
    private EditableListFileEditor m_fileeditor = new EditableListFileEditor();
    private SortedEditableList m_list = new SortedEditableList(){

        protected void modelChanged() {
            ClassPath.this.updateModel();
        }
    };

    public ClassPath() {
        this.m_jarLocFileChooser.setFileSelectionMode(2);
        this.m_jarLocFileChooser.setMultiSelectionEnabled(true);
        GenericFileFilter filter = new GenericFileFilter("Zip, Jar, or directories");
        filter.addSuffix("jar");
        filter.addSuffix("zip");
        this.m_jarLocFileChooser.addChoosableFileFilter(filter);
        this.m_fileeditor.setFileChooser(this.m_jarLocFileChooser);
        this.m_list.setEditor(this.m_fileeditor);
        this.setLayout(new BorderLayout());
        this.add("Center", this.m_list);
    }

    public void dataChanged() {
        String[] cp;
        if (this.getBaseDir() != null) {
            this.m_jarLocFileChooser.setCurrentDirectory(this.getBaseDir());
        }
        if ((cp = this.m_model.getClassPath()) == null) {
            this.m_list.setData(new Object[0]);
        } else {
            this.m_list.setData(cp);
        }
    }

    public void updateModel() {
        Object[] cpels = this.m_list.getData();
        String[] cp = new String[cpels.length];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = cpels[i].toString();
        }
        this.m_model.setClassPath(cp);
    }

    public String getLabel() {
        return "CLASSPATH_LABEL";
    }

    public String getDescription() {
        return "CLASSPATH_HELP";
    }

    public boolean needsBigSpace() {
        return true;
    }
}

