/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.DependencyConstraintMetadata;
import org.gradle.api.artifacts.DependencyConstraintsMetadata;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintsMetadataAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependenciesMetadataAdapter;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.CollectionUtils;

public class DependencyMetadataRules {
    private static final Spec<ModuleDependencyMetadata> DEPENDENCY_FILTER = new Spec<ModuleDependencyMetadata>(){

        public boolean isSatisfiedBy(ModuleDependencyMetadata dep) {
            return !dep.isPending();
        }
    };
    private static final Spec<ModuleDependencyMetadata> DEPENDENCY_CONSTRAINT_FILTER = new Spec<ModuleDependencyMetadata>(){

        public boolean isSatisfiedBy(ModuleDependencyMetadata dep) {
            return dep.isPending();
        }
    };
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser;
    private final List<VariantMetadataRules.VariantAction<? super DirectDependenciesMetadata>> dependencyActions = Lists.newArrayList();
    private final List<VariantMetadataRules.VariantAction<? super DependencyConstraintsMetadata>> dependencyConstraintActions = Lists.newArrayList();
    private final ImmutableAttributesFactory attributesFactory;

    public DependencyMetadataRules(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, ImmutableAttributesFactory attributesFactory) {
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
        this.dependencyConstraintNotationParser = dependencyConstraintNotationParser;
        this.attributesFactory = attributesFactory;
    }

    public void addDependencyAction(VariantMetadataRules.VariantAction<? super DirectDependenciesMetadata> action) {
        this.dependencyActions.add(action);
    }

    public void addDependencyConstraintAction(VariantMetadataRules.VariantAction<? super DependencyConstraintsMetadata> action) {
        this.dependencyConstraintActions.add(action);
    }

    public <T extends ModuleDependencyMetadata> List<T> execute(VariantResolveMetadata variant, List<T> dependencies) {
        ArrayList<T> calculatedDependencies = new ArrayList<T>();
        calculatedDependencies.addAll(this.executeDependencyRules(variant, dependencies));
        calculatedDependencies.addAll(this.executeDependencyConstraintRules(variant, dependencies));
        return calculatedDependencies;
    }

    private <T extends ModuleDependencyMetadata> List<T> executeDependencyRules(VariantResolveMetadata variant, List<T> dependencies) {
        ArrayList calculatedDependencies = new ArrayList(CollectionUtils.filter(dependencies, DEPENDENCY_FILTER));
        for (VariantMetadataRules.VariantAction<? super DirectDependenciesMetadata> dependenciesMetadataAction : this.dependencyActions) {
            dependenciesMetadataAction.maybeExecute(variant, (DirectDependenciesMetadata)this.instantiator.newInstance(DirectDependenciesMetadataAdapter.class, new Object[]{this.attributesFactory, calculatedDependencies, this.instantiator, this.dependencyNotationParser}));
        }
        return calculatedDependencies;
    }

    private <T extends ModuleDependencyMetadata> List<T> executeDependencyConstraintRules(VariantResolveMetadata variant, List<T> dependencies) {
        ArrayList calculatedDependencies = new ArrayList(CollectionUtils.filter(dependencies, DEPENDENCY_CONSTRAINT_FILTER));
        for (VariantMetadataRules.VariantAction<? super DependencyConstraintsMetadata> dependencyConstraintsMetadataAction : this.dependencyConstraintActions) {
            dependencyConstraintsMetadataAction.maybeExecute(variant, (DependencyConstraintsMetadata)this.instantiator.newInstance(DependencyConstraintsMetadataAdapter.class, new Object[]{this.attributesFactory, calculatedDependencies, this.instantiator, this.dependencyConstraintNotationParser}));
        }
        return calculatedDependencies;
    }
}

