/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.nativeplatform.toolchain.internal.xcode.SwiftStdlibToolLocator;
import org.gradle.process.ExecSpec;
import org.gradle.util.GFileUtils;

@Incubating
public class InstallXCTestBundle
extends DefaultTask {
    private final DirectoryProperty installDirectory = this.newOutputDirectory();
    private final RegularFileProperty bundleBinaryFile = this.newInputFile();

    @Inject
    protected SwiftStdlibToolLocator getSwiftStdlibToolLocator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void install() throws IOException {
        File bundleFile = ((RegularFile)this.bundleBinaryFile.get()).getAsFile();
        File bundleDir = ((Directory)this.installDirectory.get()).file(bundleFile.getName() + ".xctest").getAsFile();
        this.installToDir(bundleDir, bundleFile);
        File runScript = ((RegularFile)this.getRunScriptFile().get()).getAsFile();
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nXCTEST_LOCATION=`xcrun --find xctest`\nexec \"$XCTEST_LOCATION\" \"$@\" \"$APP_BASE_NAME/" + bundleDir.getName() + "\"" + "\n";
        GFileUtils.writeFile((String)runScriptText, (File)runScript);
        this.getFileSystem().chmod(runScript, 493);
    }

    private void installToDir(final File bundleDir, final File bundleFile) throws IOException {
        this.getFileOperations().sync((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from((Object)bundleFile, (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.into((Object)"Contents/MacOS");
                    }
                });
                copySpec.into((Object)bundleDir);
            }
        });
        File outputFile = new File(bundleDir, "Contents/Info.plist");
        Files.write((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict/>\n</plist>", (File)outputFile, (Charset)Charset.forName("UTF-8"));
        this.getProject().exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.setWorkingDir(bundleDir);
                execSpec.executable((Object)InstallXCTestBundle.this.getSwiftStdlibToolLocator().find());
                execSpec.args(new Object[]{"--copy", "--scan-executable", bundleFile.getAbsolutePath(), "--destination", new File(bundleDir, "Contents/Frameworks").getAbsolutePath(), "--platform", "macosx", "--resource-destination", new File(bundleDir, "Contents/Resources").getAbsolutePath(), "--scan-folder", new File(bundleDir, "Contents/Frameworks").getAbsolutePath()});
            }
        }).assertNormalExitValue();
    }

    @Internal
    public Provider<RegularFile> getRunScriptFile() {
        return this.installDirectory.file(this.getProject().provider((Callable)new Callable<CharSequence>(){

            @Override
            public CharSequence call() throws Exception {
                return FilenameUtils.removeExtension((String)((RegularFile)InstallXCTestBundle.this.bundleBinaryFile.get()).getAsFile().getName());
            }
        }));
    }

    @Internal(value="covered by getBundleBinary()")
    public RegularFileProperty getBundleBinaryFile() {
        return this.bundleBinaryFile;
    }

    @SkipWhenEmpty
    @Nullable
    @Optional
    @InputFile
    protected File getBundleBinary() {
        RegularFile bundle = (RegularFile)this.getBundleBinaryFile().get();
        File bundleFile = bundle.getAsFile();
        if (!bundleFile.exists()) {
            return null;
        }
        return bundleFile;
    }

    @OutputDirectory
    public DirectoryProperty getInstallDirectory() {
        return this.installDirectory;
    }
}

