/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskValidationContext;

public class DefaultTaskValidationContext
implements TaskValidationContext {
    private final FileResolver resolver;
    private final Collection<String> messages;
    private TaskValidationContext.Severity highestSeverity;

    public DefaultTaskValidationContext(FileResolver resolver, Collection<String> messages) {
        this.resolver = resolver;
        this.messages = messages;
        this.highestSeverity = TaskValidationContext.Severity.WARNING;
    }

    @Override
    public FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public void recordValidationMessage(TaskValidationContext.Severity severity, String message) {
        if (severity.compareTo(this.highestSeverity) > 0) {
            this.highestSeverity = severity;
        }
        this.messages.add(message);
    }

    @Override
    public TaskValidationContext.Severity getHighestSeverity() {
        return this.highestSeverity;
    }
}

