/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  lr1_k_phrase.lex
Dates:		  24 May 2004
Purpose:	  lr k constant alphabet
Grammar being parsed:
	lr1-constant-symbols       
	(file-name yacco2_lr1_k
	,name-space NS_yacco2_lr1_k)  
	{ 
		1+ terminal definitions where def is
		 terminal-key [AD AB attributes](sym-class C++ name)
		      or
		 terminal-key [AD AB attributes]
		 (sym-class C++ name {C++ directives block} ) 
		 
		 [lrk-sufx code ***] optional
	}
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |lr1_k_phrase| grammar.\fbreak
Dispatcher to parse the lr1-constant-symbols.\fbreak
\fbreak
Note: lrk-sufx directive used to append specific grammar 
writer code
to the outputted tables. 
In this case, it is external pointers
to the lrk constant symbols to lower their manufacture. 
For example, "eog" is used thoughout all the grammars --- so 
make-once use-forever attitude.\fbreak
@/
fsm	
(fsm-id "lr1_k_phrase.lex"
,fsm-filename lr1_k_phrase
,fsm-namespace NS_lr1_k_phrase
,fsm-class Clr1_k_phrase{
  user-prefix-declaration
#include "lr1_k_phrase_th.h"
#include "o2_externs.h"
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  op
   if(CWEB_MARKER != 0){
     cweb_marker__ = CWEB_MARKER;
     CWEB_MARKER=0;
   }
  ***
  constructor
   cweb_marker__ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 May 2004",fsm-debug "false"
,fsm-comments "Dispatcher to parse ``lrk-symbols'' construct.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
rules{
Rlr1_k_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "lr1-k-phrase" 
      NS_lr1_k_phrase_th::TH_lr1_k_phrase_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL { // thread has stop parsing with RSVP error
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| { // error due to no first set to start thread {
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
