                TeX Macro Enhancements for EPM 5.51a and EPM 6
                             EPMTeX Pro Version 3.1

                           Installation/Upgrade Notes

                                   Jon Hacker
                                  Rodney Korte

                                 September 1995


License Agreement:
~~~~~~~~~~~~~~~~~
You agree to abide by the license agreement contained in the on-line help
of epmtex.exe if you choose to install or use the EPMTeX macro package.


CONTENTS
~~~~~~~~
 Section 1:  What is EPMTeX and this new EPMTeX Pro?
             (a brief synopsis of what it can do)

 Section 2:  Express Installation of EPMTeX 3.1 (Pro version)
             (terse installation instructions for EPM experts)

 Section 3:  Long-Winded Installation of EPMTeX 3.1 (Pro version)
             (full installation instructions for novices)

 Appendix A: Removing a previous version of EPMTeX
             (how to remove an old version before upgrading)

 Appendix B: Disclaimer
             (Hey, you get what you pay for!)


#######################################################################

Section 1: What is EPMTeX, and this new EPMTeX Pro?
~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
EPMTeX is a sophisticated *free* macro package that integrates the TeX
typesetting system with the IBM enhanced editor EPM for OS/2.  The
EPMTeX macro suite adds a TeX pull down menu to the EPM menu bar, and
includes a PM style notebook program for configuration of the package.

Menu items in the TeX pull down menu allow the user to TeX (with any
format, e.g.  LATeX), jump to errors in the TeX source, preview
(portrait and landscape), and print (portrait and landscape) the TeX
file currently active in EPM.  Custom 'user' modes may also be defined
for special needs unique to the user.

Due to popular demand, the standard edition of EPMTeX now comes
precompiled.  The version of EPM shipped with OS/2 is all that is
required to run EPMTeX.  It is no longer necessary to obtain the EPM
macro compiler from IBM to add the core EPMTeX features.  Consequently,
installation is now greatly simplified.

EPMTeX Pro... what is this?

EPMTeX was substantially rewritten to allow it to be distributed
precompiled.  In the process, some existing features were removed due to
limitations in what can be done with a precompiled EPM macro.  Users of
earlier versions of EPMTeX may not wish to give up these features,
particularly if they are comfortable compiling macros for EPM.  For this
reason, a Pro version of the macro package is also provided.  The Pro
version does *not* come precompiled and is not recommended for novice
users.  Its installation is complicated, requires the complete EPM macro
compiler from IBM, and does not offer much more than the standard
version anyway.  It is provided solely as a comfort to our longtime
EPMTeX users.

The Pro version offers the following (minor) extra things over the
standard version:

    - The format and orientation can be chosen from either the settings
      notebook (as per the standard version) or from the EPM TeX menu.
    - The EPM TeX menu items get enabled/disabled (greyed out) as
      appropriate.  For example, if the dvi file does not exist, the
      preview and print functions will be greyed out in the menu.
    - Access to the macro source code should you wish to dabble in
      a little customization of the package.

If you wish to use EPMTeX Pro, unzip the file TeXpro.zip included with
EPMTeX 3.1 and follow the installation instructions contained in the
file readme.pro.


#######################################################################

Section 2: Express Installation Procedure (Pro version)
~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           (see also the on-line help in epmtex.exe)

NOTE: Users of older versions of EPMTeX will first have to
      expunge the old EPMTeX files before installing the new
      version. Refer to Appendix A for further instructions.

a) Create the subdirectory EPMTEX in the EPM directory.  Copy the
   contents of the EPMTeX Pro macro package (including the
   files contained in TEXPRO.ZIP) into it. Add this directory to your
   EPMPATH  environment variable.  (You could also copy them to the
   e_macros subdirectory of epm, but this makes things more confusing
   with all the other files in there already.) Reboot if you made any
   changes to config.sys.

b) Append mymnuini.add to your existing mymnuini.e file,
   or if you don't have one, copy mymnuini.add to mymnuini.e
   and put the file in a directory specified in your PATH or EPMPATH
   environment variables.

c) Append mystuff.add to your existing mystuff.e file,
   or if you don't have one, copy mystuff.add to mystuff.e
   and put the file in a directory specified in your PATH or EPMPATH
   environment variables.

d) CAUTION: We recommend you backup the original epm.ex and extra.ex in
            case you have problems and wish to get back to the original
            configuration.

   Recompile (version 6 users can skip the extra.e recompile)

	etpm epm
	etpm extra
	etpm tex

   Make sure the resulting epm.ex, extra.ex, and tex.ex files
   are located in a directory specified in your PATH or EPMPATH
   environment variables.  Also, make sure there are no other
   older copies of epm.ex, extra.ex, and tex.ex in your PATH that
   could override your newer versions.

e) Copy bpmcc.dll to any directory in your LIBPATH.  Copy
   epmtex.exe and epmtex.hlp anywhere to your liking, it doesn't
   matter where, but keep them together.

f) Run epmtex.exe and fill in the notebook to describe your local TeX
   environment.

g) Start EPM.  The TeX menu should be visible.  Load a TeX
   file and test it out!


#######################################################################

Section 3: Long-Winded Installation Procedure (Pro version)
~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
          (see also the on-line help in epmtex.exe)

NOTE: Users of older versions of EPMTeX will first have to
      expunge the old EPMTeX files before installing the new
      version. Refer to Appendix A for further instructions.

Requirements:
~~~~~~~~~~~~
The EPMTeX Pro macros supplied with this package need to be compiled
before they can be incorporated into EPM.  You will need to obtain the
complete EPM 5.51a package from IBM to do this.  Alternatively, the
package can also be used with the new 32 bit version 6 of EPM.

WARNING:  There are several versions of epm 5.51.  Make sure you get the
          latest version.  It should say 5.51a in the Product
          Information dialog box under the Help menu.

The EPM package is available for free from the following Internet sites:

software.watson.ibm.com   /pub/os2/epm
ftp-os2.cdrom.com         /pub/os2/ibm/epm

It should also be available from major OS/2 BBS services.


Installation of EPM 5.51a:
~~~~~~~~~~~~~~~~~~~~~~~~~
If you are not already familiar with compiling EPM macros on your machine,
read this section for additional help.

The installation of the EPM 5.51a package is sufficiently confusing that I
will try to give some hints to get you going as fast as possible.

The EPM package includes two hypertext files; the EPM User's Manual, and
the EPM Technical Reference.  Both of these manuals provide a wealth of
information on EPM.  It is highly recommended that you spend some time
becoming familiar with EPM, and the E macro language by reading through them.

1) Decide on a location for your EPM files.  I suggest something like
   \os2\epm or \epm.  I would avoid using the \os2\apps directory
   where the binaries for EPM 5.51 are placed by default during the
   the installation of OS/2.  There's just too much other crap in there
   already.

2) Unzip the EPM 5.51a files.  You will want to take care where you put
   everything.  I recommend the following directory structure as suggested in
   the EPMBBS.TXT file in the EPM package from IBM.

WARNING:  If you are using Warp v3.0, it is recommended you keep the
          original Warp versions of epm.exe, epm.hlp, and the
          etk*551.dll files as they are newer than the versions
          supplied with the IBM EPM compiler package.

EPMAPP.ZIP - Unzip into your epm directory (eg. \os2\epm)
   EPM.EXE     - The 5.51a version of the editor (see Warp warning above)
   ETPM.EXE    - The 5.51a version of the macro compiler
   PMMORE.EXE  - Useful for debugging Rexx macros; entering RXSHELL from
                 EPM will start PMMORE and redirect STDOUT to this window.
                 SAY and TRACE output will be displayed there.
   *.EX        - the 5.51a version of the compiled macros
   EPMHELP.QHL - the updated "quick help" file
   EPMTECH.NDX - An index file for getting macro programmer help.

EPMBK.ZIP - Unpack into a directory in your BOOKSHELF path
   EPMUSERS.INF - The EPM User's Guide
   EPMTECH.INF  - The EPM Macro Programmer's Technical Reference

EPMDLL.ZIP - Unpack into \os2\apps\dll or a directory in your LIBPATH.
             Delete the obsolete ETK*550.DLL files leftover from EPM 5.50.
    ETK*551.DLL - The E Toolkit DLLs. (see Warp warning above)

EPMMAC.ZIP - Create a subdirectory under EPM called E_MACROS and unzip
             into it.
     *.e - contains the macro files used to build the standard *.ex files.

EPMHLP.ZIP - Updated EPM.HLP; unpack into \os2\help  (see Warp warning above)

EMPSMP.ZIP - Create a subdirectory under EPM called sampmacs and unzip
             this file into it.
     *.e - Sample E macro code; includes both useful programs and
           building blocks that you can use in writing your own code.

EPMREX.ZIP - Create a subdirectory under EPM called EREXX, unzip this
             file into it and add it to your EPMPATH.
     *.erx - contains some sample EPM / Rexx macros.

EPMASI.ZIP - Create a subdirectory under EPM called myassist, unzip this
             file into it and add it to your EPMPATH.
     An alternative approach to syntax-assisted editing; makes it easy to
     add your own expansions.  Includes sample files for OS/2 and PM APIs,
     C, and Bookmaster.

EPMATR.ZIP - Create a subdirectory under EPM called epmattr, unzip this
             file into it and add it to your EPMPATH.
     Sample code for doing things with EPM's attribute support.


3) Edit your config.sys file and make sure that your new epm directory
   is included in your PATH statement.  If you have IBM's TCP/IP v2.0 networking
   package, make sure your epm directory comes before \tcpip\bin in your
   PATH, or delete the redundant EPM files as outlined in step (6).

4) Edit your config.sys file and make sure that the e_macros, sampmacs,
   erexx, myassist, and epmattr subdirectories are included in your EPMPATH.
   EPMPATH is used by the ETPM compiler to find macro files that are not in
   your current directory.

5) Use a file finding utility to hunt down all *.ex files.  These are
   the compiled E macros that EPM executes.  The OS/2 installation puts
   them in \os2\apps.  Delete all redundant or older *.ex files on your
   system.  You only need them in your EPM directory.  Having multiple
   copies of the *.ex files may result in unexpected behaviour from EPM.

----- OPTIONAL -------------------------------------------------------------
6) If you have IBM's TCP/IP v2.0 networking package, there will be some more
   *.ex files in \tcpip\bin.  You can delete most of these files, or, if you
   prefer, just make sure your your epm directory comes before \tcpip\bin in
   your PATH,

WARNING: LEAVE THE FOLLOWING UNIQUE TO LAMAIL *.EX FILES IN \TCPIP\BIN
                             ~~~~~~
          EPMLIST.EX
          LAMEXTRA.EX
          MAILLIST.EX
-----------------------------------------------------------------------------

7) Find all other copies EPM.EXE and delete them.  Likely hiding places
   are \os2\apps and \tcpip\bin.  You only need the one copy of epm.exe and it
   should be in your epm directory.  For Warp users, move the existing EPM.EXE
   from \os2\apps to your epm directory.

8) Find any copies of ETK*550.DLL (v 5.50 dll's) and delete them.  Likely
   hiding places are \os2\apps\dll  and \tcpip\dll.  You only need the v5.51a
   dll's and they should be put somewhere in your LIBPATH (\os2\apps\dll is as
   good as any). For Warp users, keep the existing ETK*551.DLL files
   in \os2\apps\dll as they are newer than the ones supplied with the
   compiler package.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
NOTE: Unfortunately, when you apply a CSD or Service Pack, copies of
      EPM will again be placed in \os2\apps or \tcpip\bin and you will need
      to do some housekeeping to get things back in order.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

9)  I advise you get the spell checker option EPM_SPEL.ZIP for EPM.  It is a
    nice thing to have and is available from the following INTERNET source.

               ftp-os2.cdrom.com          /pub/os2/2_x/editors

    You will need to put the location of the dictionary (us.dct file) in the
    paths section of the EPM preferences notebook.  I put mine in
    \epm\lexam.

10) You should now be ready to compile your E macros.  First, though,
    reboot if you made any changes to config.sys.


COMPILING THE EPMTeX Pro MACROS:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
1)  Create the subdirectory EPMTEX in the EPM directory.  Copy the
    contents of the EPMTeX Pro macro package (including the
    files contained in TEXPRO.ZIP) into it. Add this directory to your
    EPMPATH  environment variable.  (You could also copy them to the
    e_macros subdirectory of epm, but this makes things more confusing
    with all the other files in there already. Reboot if you made any
    changes to config.sys.

    Delete the file TEX.EX that comes with the standard version of
    EPMTeX.  You will compile your own copy of this file during the
    installation procedure.

2)  Read the section in the EPM user's manual 'Changing the default
    configuration' to understand the use of EPM's configuration constants
    and what they can do.  The binaries included with the EPM package were
    compiled with the constants defined in epmgcnf.smp in your e_macros
    subdirectory.  If these are OK with you, copy epmgcnf.smp to a file
    called mycnf.e in your e_macros directory.  Alternatively, read the
    EPM documentation on compiler options and build your own custom mycnf.e
    file to suit your taste.

    We would suggest that in your MYCNF.E file you enable the ring by including
    the following:

      MY_RING_ENABLED = 1
      RING_OPTIONAL = 0

3)  If you don't have a mystuff.e file in your e_macros directory,
    (maybe because this is your first stab at compiling E macros) then
    copy mystuff.add to mystuff.e.

    If you already have a mystuff.e file in your e_macros directory,
    then append the contents of mystuff.add to the end of it.

4)  If you don't have a mymnuini.e file in your e_macros directory, then
    copy mymnuini.add to mymnuini.e.

    If you already have a mymnuini.e file in your e_macros directory (it is
    possible that you may already have an existing mymnuini.e file if you
    have made other modifications to EPM's menu bar already), then
    append the contents of mymnuini.add to it.

5)  To be safe, make backup copies of your epm.ex and extra.ex files in
    your epm directory.  Then if things go awry you can get back to the
    original epm configuration.

6)  Make the epm directory your current directory, and type
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    etpm epm

    The etpm compiler will execute and compile your epm.e macro.  The TeX
    stuff in mystuff.e, mymnuini.e, and your config switches in mycnf.e will
    automatically be included.  If etpm complains it can't find a file, you
    probably have your EPMPATH incorrectly defined.  It should point to all
    directories containing E macro files (*.e).

7)  If that goes well, type

    etpm extra

    This will compile the extra stuff that wouldn't all fit in the epm.ex
    file and generate a new extra.ex file.  (Note: this step is
    unnecessary with EPM version 6.)

8)  If that goes well, type

    etpm tex

    This will compile the actual TeX support.

9)  Make sure the files epm.ex, extra.ex, and tex.ex created above
    are located in a directory specified in your PATH or
    EPMPATH environment variables.  Also, make sure there are no other
    older copies of epm.ex, extra.ex, and tex.ex in your PATH that could
    override your newer versions.

10) Copy bpmcc.dll to any directory in your LIBPATH.  Put
    epmtex.exe and epmtex.hlp anywhere to your liking, it doesn't
    matter where, but keep them together.

11) Run epmtex.exe and fill in the notebook to describe your local TeX
    environment.

12) Start EPM.  The TeX menu should be visible.  Load a TeX
    file and test it out!


#######################################################################

APPENDIX A:   Upgrading from an earlier EPMTeX version.

To install over a previous version of EPMTeX you will need to first
delete the files added by the earlier version.

a) Remove the old EPMTeX version from your epm files:

  1) Delete the EPMTeX part of Mymnuini.e
  2) Delete the EPMTeX part of Mykeys.e (if any)
  3) Delete the EPMTeX part of Mykeyset.e (if any)
  4) Delete the EPMTeX part of Mystuff.e (if any)
  5) Delete the EPMTeX constants from Mycnf.e  (This is optional
     but the constants are no longer used)
  6) delete the old tex.ex (if any)

b) Recompile (version 6 users can skip the extra.e recompile)
   etpm epm
   etpm extra

c) Now you should have a plain version of EPM, like
   it was before you installed EPMTeX.  Try running EPM
   and make sure the TeX menu is gone.


#######################################################################

APPENDIX B: Disclaimer:
            ~~~~~~~~~~
We are by no means experts on programming the EPM enhanced editor.  While these
TeX enhancements have been fairly thoroughly tested, there could easily be
oversights on our parts that result in problems for some configurations of EPM.
If you think you have found a genuine bug, or would like to make suggestions,
contributions, or enhancements to this code please drop one of us a note.
Since we have released this code without charge, we cannot offer a warranty
or customer support.  Everything you need to get going should be available
in the install.doc file and IBM supplied EPM documentation.

9/95
Jon Hacker
INTERNET: hacker@patagonia.bellcore.com

Rodney Korte
Penn State, State College, PA
INTERNET: korte@sabine.psu.edu

