/*****

      $Source: d:\gunther\source\grc/RCS/wstring.c,v $
      $Author: gunther $
      $Date: 1995/12/29 23:49:21 $
      $Revision: 1.2 $

 *****/

#include <string.h>
#include <ctype.h>

#include "wstring.h"

wchar_t
wtoupper(wchar_t s)
{
    char c;

    wctomb(&c, s);
    c = toupper(c);
    mbtowc(&s, &c, 1);
    return s;
}

wchar_t
wtolower(wchar_t s)
{
    char c;
    
    wctomb(&c, s);
    c = tolower(c);
    mbtowc(&s, &c, 1);
    return s;    
}


int 
wcscmp(wchar_t *s1, wchar_t *s2)
{
/*
    return CompareStringW(LOCALE_USER_DEFAULT, 0, (WCHAR *) s1, -1, (WCHAR *) s2, -1) - 2;
*/
    while(*s1 && *s2)
    {
        if(*s1 != *s2)
            return *s1 - *s2;
    }

    return *s1 - *s2;
}


int 
wcscasecmp(wchar_t *s1, wchar_t *s2)
{
/*
    return CompareStringW(LOCALE_USER_DEFAULT, 1, (WCHAR *) s1, -1, (WCHAR *) s2, -1) - 2;
*/

    while(*s1 && *s2)
    {
        wchar_t wc1 = wtoupper(*s1);
        wchar_t wc2 = wtoupper(*s2);

        if(wc1 != wc2)
            return wc1 - wc2;

       s1++;
       s2++;
    }

    return wtoupper(*s1) - wtoupper(*s2);
}


int
wcslen(wchar_t *u_string)
{
	int length = 0;

	while(*u_string) 
	{
		u_string++;
		length++;
	}

	return length;
}


wchar_t *
wcscpy(wchar_t *u_dest, wchar_t *u_src)
{
    wchar_t *ret = u_dest;

    while(*u_src)
        *u_dest++ = *u_src++;

    *u_dest = 0;
    
    return ret;
}

#if !defined(__EMX__)
int
mbtowc(wchar_t *wc, __const__ char *mb, size_t n)
{
    if(wc && mb)
    {
        *wc = (((wchar_t) *mb) << 8) & 0xFF00;
        return count;
    }

    return 0;
}


int
wctomb(char *mb, wchar_t wc)
{
    if(mb)
    {
        *mb = (char) ((wc >> 8) & 0x00FF);
        return count;
    }

    return 0;
}


size_t
wcstombs(char *mbs, __const__ wchar_t *wcs, size_t buflen)
{
    register size_t i;

    for(i = 0; *wcs && (i < buflen); wcs++)
        i += wctomb(mbs + i, *wcs);

    return i;
}


size_t
mbstowcs(wchar_t *wcs, __const__ char *mbs, size_t count)
{
    register size_t i;

    for(i = 0; *mbs && (i < count); )
    {
        register int delta = mbtowc(wcs + i, mbs, sizeof(char));
        i += delta;
        mbs += delta;
    }

    return i;
}

#endif

/*
int
ansi2uni(short *uni, char *ansi)
{
    return MultiByteToWideChar(CP_ACP, 
                               MB_PRECOMPOSED, 
                               ansi, 
                               -1, 
                               uni, 
                               strlen(ansi)+1);
}



int 
uni2ansi(char *ansi, short *uni)
{
    return WideCharToMultiByte(CP_ACP, 
                               WC_COMPOSITECHECK | WC_SEPCHARS, 
                               uni, 
                               -1, 
                               ansi, 
                               wstrlen(uni) + 1, 
                               NULL, 
                               NULL);
}

*/

