## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "scilabMode.tcl"
 #                                    created: 15/4/97 {4:03:22 pm} 
 #                                last update: 24/2/1999 {9:38:59 pm} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 #  Mode for 'Scilab'
 #  
 # Installation:
 # 
 #  Requires Alpha version 7.0 or newer.  Just drop this file into
 #  the Alpha:Tcl:Modes: folder, rebuild your Tcl indices (using
 #  the Tcl menu which will be there when you read this file in Alpha)
 #  then quit and restart Alpha.  Now any file ending in '.sci' 
 #  automatically opens in Scilab mode.  You also need to paste the
 #  included icon from 'newMenuIcons.rsrc' into Alpha.  If for some
 #  reason you got this file without that rsrc file, then add the line
 #  'set scilabMenu "Scil"' to your prefs.tcl file.  Note: the more
 #  useful features of this mode are only available if you've
 #  installed "Vince's Additions".
 #  
 #  We can't do too much exciting, since Scilab only handles an
 #  'open' apple-event --- therefore it's not usefully scriptable.
 #  
 # Features:
 # 
 #  Automatically scans Scilab's 'Help' directory to pick up all
 #  Scilab keywords so they can be coloured.
 #  
 #  Command-clicking on a keyword opens up a window with the help
 #  information for that keyword (optionally this can be made to
 #  open in Scilab itself)
 #  
 # If Vince's Additions is installed, the following features are
 # also available:
 # 
 #  Keywords can be completed (enter the first few letters 
 #  followed by 'cmd-tab')
 #  
 #  Function calls can be extended to list their arguments,
 #  with template stops at each argument (again use cmd-tab).
 #  
 #  e.g. type 'sysl<cmd-tab>' and it is completed to 'syslin'
 #  and immediately expanded to:
 #  	syslin(<dom>,<A>,<B>,<C ><[,D [,x0] ]>)
 #  pressing tab moves from one argument to the next, highlighting
 #  each argument in turn for each entry.
 #  
 # This file is copyright Vince Darley 1997, but freely distributable
 # provided you note any modifications you make below.
 # ###################################################################
 ##

alpha::mode Scil 1.0 scilabMenu {*.sci *.dem} scilabMenu {
    addMenu scilabMenu "283"
}

newPref f alphaOpensHelpFiles 1 Scil
newPref v wordBreak {[\w_]+} Scil
newPref v wordBreakPreface {[^_\w]} Scil
newPref v stringColor green Scil
newPref v commentColor red Scil
newPref v keywordColor blue Scil

proc scilabMenu {} {}

Menu -n $scilabMenu -p Scil::menuProc {
    "/S<U<OswitchToScilab"
    "(-"
    "/K<U<OopenFileInScilab"
    "/K<U<O<BswitchFileToScilab"
    "/C<O<UsetClipboardToExecFile"
    "rebuildScilabKeywords"
}


proc Scil::menuProc {menu item} {
    switch -- $item {
	switchToScilab {app::launchFore SLab}
	openFileInScilab {
	    openAndSendFile SLab
	}
	switchFileToScilab {
	    openAndSendFile SLab
	    killWindow
	}
	setClipboardToExecFile {
	    putScrap "exec('[win::CurrentTail]')"
	}
	rebuildScilabKeywords {Scil::RebuildElectrics}
    }
}

set completions(Scil) \
  {completion::cmd completion::electric completion::word}

proc Scil::RebuildElectrics {} {
    # Get keywords by looking for all help documents,
    # simple but effective.  There may be a better way.
    global Scilcmds PREFS Scilelectrics
    set p [pwd]
    set dir  [file join [file dirname [nameFromAppl SLab]] man]
    cd $dir
    regsub -all ".hlp" [glob *.hlp] "" Scilcmds
    cd $p
    set Scilcmds " ${Scilcmds} "
    set fout [open [file join ${PREFS} ScilData] w]
    puts $fout "set Scilcmds \{${Scilcmds}\}"
    foreach f $Scilcmds {
	message "scanning $f"
	set fileid [open [file join ${dir} ${f}.hlp] r]
	set contents [read $fileid]
	close $fileid
	if [regexp "NAME\[ \r\n\t\]+${f} - (\[^\r\n\]*)\[ \r\n\t\]+CALLING SEQUENCE\[ \r\n\t\]+(${f}|\[^=\]+= *${f})(\(\[^\r\n\]+)\)\[ \r\n\t]" \
	  $contents "" desc "" arg] {
	    if [regexp  {\((.*)\)(.*)} $arg "" in after] {
		if [regexp {(, *)?\[.*\]} $in brace] {
		    regsub {(, *)?\[.*\]} $in {} in
		    regsub -all {,} $in {,} in
		    if {$in != ""} {
			regsub {} $in "${brace}" in
			set in "(${in})$after"
		    } else {
			regsub {} $in "${brace}" in
			set in "(${in})$after"
		    }
		} else {
		    regsub -all {,} $in {,} in
		    if {$in != ""} {
			set in "(${in})$after"
		    } else {
			set in "()$after"
		    }
		}
		set Scilelectrics($f) "${in}$desc"				
	    } else {
		set Scilelectrics($f) "${arg}$desc"
	    }
	    puts $fout "set Scilelectrics($f) \{$Scilelectrics($f)\}"
	}
    }
    close $fout
    message "done"
    
}

## 
 # -------------------------------------------------------------------------
 # 
 # "Scil::DblClick" --
 # 
 #  Open a help file for the given command, either in Alpha or externally
 #  in Scilab.
 # -------------------------------------------------------------------------
 ##
proc Scil::DblClick {from to shift option control} {
	select $from $to
	set text [getSelect]
	set d "[file join [file dirname [nameFromAppl SLab]] man]"
	set f "[file join ${d} ${text}.hlp]"
	if [file exists $f] {
		global alphaOpensHelpFiles
		if {$alphaOpensHelpFiles} {
			file::openQuietly $f
			changeMode Scil
			global win::Modes
			set "win::Modes($f)" "Scil"
			setWinInfo read-only 1
		} else {
			set name [file tail [app::launchFore SLab]]
			sendOpenEvent noReply $name $f
		}		
	} else {
		alertnote "No such help file exists in Scilab's 'man' directory."
	}
}

if [file exists [file join ${PREFS} ScilData]] {
	source [file join ${PREFS} ScilData]
} else {
	alertnote "The first time you use this mode I must build a command database."
	Scil::RebuildElectrics
}
regModeKeywords  -e {//} -c $ScilmodeVars(commentColor) \
	-k $ScilmodeVars(keywordColor)  -s $ScilmodeVars(stringColor) \
	Scil $Scilcmds
