/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.viewer.util.FileLocationListener;

public class FileLocationServer
implements Runnable {
    private static FileLocationServer instance = new FileLocationServer();
    private ServerSocket ssocket;
    private FileLocationListener listener;

    private FileLocationServer() {
    }

    public static FileLocationServer getInstance() {
        return instance;
    }

    public boolean isRunning() {
        return this.ssocket != null;
    }

    public void stop() {
        if (this.ssocket == null) {
            return;
        }
        try {
            Socket s = new Socket("localhost", this.ssocket.getLocalPort());
            s.getOutputStream().write("QUIT\n".getBytes());
            s.close();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException e) {
            TexlipsePlugin.log("Stopping FileLocation server: ", e);
        }
    }

    public void setListener(FileLocationListener listener) {
        this.listener = listener;
    }

    public void run() {
        this.ssocket = null;
        try {
            this.ssocket = new ServerSocket(TexlipsePlugin.getDefault().getPreferenceStore().getInt("fileLocPort"));
        }
        catch (IOException e) {
            TexlipsePlugin.log("Starting server", e);
        }
        try {
            while (this.ssocket != null) {
                Socket csocket = this.ssocket.accept();
                BufferedReader is = new BufferedReader(new InputStreamReader(csocket.getInputStream()));
                String line = null;
                while ((line = is.readLine()) != null) {
                    this.parseLine(line);
                }
            }
        }
        catch (IOException e) {
            this.ssocket = null;
            TexlipsePlugin.log("Server error: ", e);
        }
    }

    private void parseLine(String line) {
        int index = line.lastIndexOf(58);
        if (index > 0) {
            String file = line.substring(0, index);
            int i = index + 1;
            while (i < line.length() && Character.isDigit(line.charAt(i))) {
                ++i;
            }
            String num = line.substring(index + 1, i);
            int lineNumber = -1;
            try {
                lineNumber = Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.listener != null) {
                this.listener.showLineOfFile(file, lineNumber);
            }
        } else if (line.startsWith("QUIT")) {
            this.ssocket = null;
        }
    }
}

