/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class LatexParserUtils {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;

    public static boolean isEscaped(String input, int index) {
        while (index > 0) {
            if (input.charAt(--index) != '\\') {
                return false;
            }
            if (index == 0 || input.charAt(index - 1) != '\\') {
                return true;
            }
            --index;
        }
        return false;
    }

    public static int getStartofLine(String input, int index) {
        int pos = index;
        char c = input.charAt(pos);
        while (pos > 0 && c != '\r' && c != '\n') {
            c = input.charAt(--pos);
        }
        if (pos == 0) {
            return pos;
        }
        return pos + 1;
    }

    public static boolean isInsideComment(String input, int index) {
        int lastLine;
        int p = lastLine = LatexParserUtils.getStartofLine(input, index);
        while (p < index) {
            char c = input.charAt(p);
            if (c == '%') {
                return true;
            }
            if (c == '\\') {
                p += 2;
                continue;
            }
            ++p;
        }
        return false;
    }

    private static boolean testForCommand(String input, int commandLength, int index) {
        if (LatexParserUtils.isEscaped(input, index)) {
            return false;
        }
        return (index + commandLength == input.length() || !Character.isLetter(input.charAt(index + commandLength))) && !LatexParserUtils.isInsideComment(input, index);
    }

    public static int findCommand(String input, String command, int fromIndex) {
        int pos = input.indexOf(command, fromIndex);
        while (pos != -1) {
            if (LatexParserUtils.testForCommand(input, command.length(), pos)) {
                return pos;
            }
            pos = input.indexOf(command, pos + command.length());
        }
        return -1;
    }

    private static int findLastCommand(String input, String command, int fromIndex) {
        int pos = input.lastIndexOf(command, fromIndex);
        while (pos != -1) {
            if (LatexParserUtils.testForCommand(input, command.length(), pos)) {
                return pos;
            }
            pos = input.lastIndexOf(command, pos - 1);
        }
        return -1;
    }

    public static int findPeerChar(String input, int offset, int anchor, char opening, char closing) {
        int stack = 1;
        int index = offset;
        while (stack > 0) {
            index = anchor == 1 ? ++index : --index;
            if (index < 0 || index >= input.length()) {
                index = -1;
                break;
            }
            char c = input.charAt(index);
            if (c == closing && !LatexParserUtils.isEscaped(input, index) && !LatexParserUtils.isInsideComment(input, index)) {
                --stack;
                continue;
            }
            if (c != opening || LatexParserUtils.isEscaped(input, index) || LatexParserUtils.isInsideComment(input, index)) continue;
            ++stack;
        }
        return index;
    }

    public static IRegion getCommandArgument(String input, int index) {
        int pos = index;
        int length = input.length();
        if (input.charAt(index) == '\\') {
            ++pos;
        }
        while (pos < length && Character.isLetter(input.charAt(pos))) {
            ++pos;
        }
        while (pos < length && Character.isWhitespace(input.charAt(pos))) {
            ++pos;
        }
        if (pos == length) {
            return null;
        }
        if (input.charAt(pos) == '{') {
            int end = LatexParserUtils.findPeerChar(input, pos + 1, 1, '{', '}');
            if (end == -1) {
                return null;
            }
            return new Region(pos + 1, end - pos - 1);
        }
        return null;
    }

    public static IRegion getCommand(String input, int index) {
        if ("".equals(input)) {
            return null;
        }
        int pos = index;
        if (pos >= input.length()) {
            pos = input.length() - 1;
        }
        if (pos < 0) {
            return null;
        }
        if (LatexParserUtils.isInsideComment(input, pos)) {
            return null;
        }
        boolean whiteSpace = false;
        if (pos > 0 && input.charAt(pos) == '}') {
            --pos;
        }
        char c = input.charAt(pos);
        while (pos > 0 && c != '\\' && c != '{' && c != '}' && c != '%' || LatexParserUtils.isEscaped(input, pos)) {
            if (Character.isWhitespace(c)) {
                whiteSpace = true;
            }
            c = input.charAt(--pos);
        }
        if (c == '\\' && !whiteSpace) {
            int l = 1;
            while (pos + l < input.length() && Character.isLetter(input.charAt(pos + l))) {
                ++l;
            }
            if (l == 1) {
                return null;
            }
            return new Region(pos, l);
        }
        if (c == '{') {
            if (pos == 0) {
                return null;
            }
            int l = -1;
            int ws = 0;
            c = input.charAt(pos + l);
            while (pos + l > 0 && Character.isWhitespace(c)) {
                --ws;
                c = input.charAt(pos + --l);
            }
            while (pos + l > 0 && Character.isLetter(c)) {
                c = input.charAt(pos + --l);
            }
            if (pos + l >= 0 && c == '\\' && !LatexParserUtils.isEscaped(input, pos + l)) {
                return new Region(pos + l, -l + ws);
            }
        }
        return null;
    }

    private static IRegion findEnvironment(String input, String envName, String command, int fromIndex) {
        int pos = input.indexOf("{" + envName + "}", fromIndex + command.length());
        while (pos != -1) {
            int end = pos + envName.length() + 2;
            int beginStart = LatexParserUtils.findLastCommand(input, command, pos);
            if (beginStart != -1 && beginStart >= fromIndex) {
                while (pos != beginStart + command.length() && Character.isWhitespace(input.charAt(--pos))) {
                }
                if (pos == beginStart + command.length()) {
                    return new Region(beginStart, end - beginStart);
                }
            }
            pos = input.indexOf("{" + envName + "}", pos + envName.length() + 2);
        }
        return null;
    }

    private static IRegion findLastEnvironment(String input, String envName, String command, int fromIndex) {
        int pos = input.lastIndexOf("{" + envName + "}", fromIndex);
        while (pos != -1) {
            int end = pos + envName.length() + 2;
            int beginStart = LatexParserUtils.findLastCommand(input, command, pos);
            if (beginStart != -1 && beginStart <= fromIndex) {
                while (pos != beginStart + command.length() && Character.isWhitespace(input.charAt(--pos))) {
                }
                if (pos == beginStart + command.length()) {
                    return new Region(beginStart, end - beginStart);
                }
            }
            pos = input.lastIndexOf("{" + envName + "}", pos - 1);
        }
        return null;
    }

    public static IRegion findBeginEnvironment(String input, String envName, int fromIndex) {
        return LatexParserUtils.findEnvironment(input, envName, "\\begin", fromIndex);
    }

    public static IRegion findEndEnvironment(String input, String envName, int fromIndex) {
        return LatexParserUtils.findEnvironment(input, envName, "\\end", fromIndex);
    }

    public static IRegion findMatchingEndEnvironment(String input, String envName, int beginIndex) {
        IRegion nextEnd;
        int pos = beginIndex + 1;
        int level = 0;
        do {
            nextEnd = LatexParserUtils.findEndEnvironment(input, envName, pos);
            IRegion nextBegin = LatexParserUtils.findBeginEnvironment(input, envName, pos);
            if (nextEnd == null) {
                return null;
            }
            if (nextBegin == null) {
                --level;
                pos = nextEnd.getOffset() + envName.length() + 6;
                continue;
            }
            level = nextBegin.getOffset() > nextEnd.getOffset() ? --level : ++level;
            pos = nextBegin.getOffset() + envName.length() + 8;
        } while (level >= 0);
        return nextEnd;
    }

    public static IRegion findMatchingBeginEnvironment(String input, String envName, int beginIndex) {
        IRegion nextBegin;
        int pos = beginIndex;
        int level = 0;
        do {
            IRegion nextEnd = LatexParserUtils.findLastEnvironment(input, envName, "\\end", pos);
            nextBegin = LatexParserUtils.findLastEnvironment(input, envName, "\\begin", pos);
            if (nextBegin == null) {
                return null;
            }
            if (nextEnd == null) {
                --level;
                pos = nextBegin.getOffset();
                continue;
            }
            level = nextEnd.getOffset() > nextBegin.getOffset() ? ++level : --level;
            pos = nextEnd.getOffset();
        } while (level >= 0);
        return nextBegin;
    }
}

