/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.util.StringTokenizer;
import net.sourceforge.texlipse.builder.AbstractProgramRunner;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IResource;

public class MakeindexRunner
extends AbstractProgramRunner {
    protected String getWindowsProgramName() {
        return "makeindex.exe";
    }

    protected String getUnixProgramName() {
        return "makeindex";
    }

    public String getDescription() {
        return "Makeindex program";
    }

    public String getDefaultArguments() {
        return "%input -s %style";
    }

    public String getArguments(IResource resource) {
        String args = super.getArguments(resource);
        String style = TexlipseProperties.getProjectProperty((IResource)resource.getProject(), "makeIndSty");
        args = style != null && style.length() > 0 ? args.replaceAll("%style", style) : args.replaceAll("-s\\s+%style", "");
        return args;
    }

    public String getInputFormat() {
        return "idx";
    }

    public String getOutputFormat() {
        return "ind";
    }

    protected boolean parseErrors(IResource resource, String output) {
        boolean errorsFound = false;
        StringTokenizer st = new StringTokenizer(output, "\r\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!line.endsWith("not found.")) continue;
            errorsFound = true;
            MakeindexRunner.createMarker(resource, null, line);
        }
        return errorsFound;
    }
}

