/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.DoubleMeta;
import com.swabunga.spell.engine.EditDistance;
import com.swabunga.spell.engine.GenericTransformator;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.Transformator;
import com.swabunga.spell.engine.Word;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class SpellDictionaryASpell
implements SpellDictionary {
    protected Transformator tf;

    public SpellDictionaryASpell(File file) throws IOException {
        this.tf = file == null ? new DoubleMeta() : new GenericTransformator(file);
    }

    public SpellDictionaryASpell(File file, String string) throws IOException {
        this.tf = file == null ? new DoubleMeta() : new GenericTransformator(file, string);
    }

    public SpellDictionaryASpell(Reader reader) throws IOException {
        this.tf = reader == null ? new DoubleMeta() : new GenericTransformator(reader);
    }

    public List getSuggestions(String string, int n) {
        return this.getSuggestions(string, n, null);
    }

    public List getSuggestions(String string, int n, int[][] nArray) {
        Object object;
        int n2;
        Object object2;
        int n3;
        Object object3;
        char c;
        Object object4;
        int n4;
        if (nArray == null) {
            nArray = new int[0][0];
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        String string2 = this.getCode(string);
        hashtable.put(string2, string2);
        Vector vector = this.getWordsFromCode(string, hashtable);
        hashtable = new Hashtable();
        char[] cArray = string.toCharArray();
        for (n4 = 0; n4 < string.length() - 1; ++n4) {
            object4 = cArray[n4];
            cArray[n4] = c = cArray[n4 + 1];
            cArray[n4 + 1] = object4;
            object3 = this.getCode(new String(cArray));
            hashtable.put(object3, object3);
            cArray[n4] = object4;
            cArray[n4 + 1] = c;
        }
        object3 = this.tf.getReplaceList();
        cArray = string.toCharArray();
        for (n4 = 0; n4 < string.length(); ++n4) {
            char c2 = cArray[n4];
            for (n3 = 0; n3 < ((char[])object3).length; ++n3) {
                cArray[n4] = object3[n3];
                String string3 = this.getCode(new String(cArray));
                hashtable.put(string3, string3);
            }
            cArray[n4] = c2;
        }
        string = string + " ";
        cArray = string.toCharArray();
        int n5 = cArray.length - 1;
        while (true) {
            for (n3 = 0; n3 < ((char[])object3).length; ++n3) {
                cArray[n5] = object3[n3];
                object2 = this.getCode(new String(cArray));
                hashtable.put(object2, object2);
            }
            if (n5 == 0) break;
            cArray[n5] = cArray[n5 - 1];
            --n5;
        }
        string = string.trim();
        cArray = string.toCharArray();
        object2 = new char[cArray.length - 1];
        for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
            object2[n2] = cArray[n2];
        }
        object4 = cArray[cArray.length - 1];
        n2 = ((Object)object2).length;
        while (true) {
            object = this.getCode(new String(cArray));
            hashtable.put(object, object);
            if (n2 == 0) break;
            c = object4;
            object4 = object2[n2 - 1];
            object2[n2 - 1] = c;
            --n2;
        }
        hashtable.remove(string2);
        object = this.getWordsFromCode(string, hashtable);
        if (((Vector)object).size() == 0 && vector.size() == 0) {
            this.addBestGuess(string, vector, nArray);
        }
        Collections.sort(vector, new Word());
        Collections.sort(object, new Word());
        vector.addAll(object);
        return vector;
    }

    private void addBestGuess(String string, Vector vector) {
        this.addBestGuess(string, vector, null);
    }

    private void addBestGuess(String string, Vector vector, int[][] nArray) {
        Object object;
        if (nArray == null) {
            nArray = new int[0][0];
        }
        if (vector.size() != 0) {
            throw new InvalidParameterException("the wordList vector must be empty");
        }
        int n = Integer.MAX_VALUE;
        String string2 = this.getCode(string);
        List list = this.getWords(string2);
        LinkedList<Word> linkedList = new LinkedList<Word>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            int n2 = EditDistance.getDistance(string, (String)object, nArray);
            if (n2 > n) continue;
            n = n2;
            Word word = new Word((String)object, n2);
            linkedList.add(word);
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (Word)iterator.next();
            if (((Word)object).getCost() != n) continue;
            vector.add(object);
        }
    }

    private Vector getWordsFromCode(String string, Hashtable hashtable) {
        Configuration configuration = Configuration.getConfiguration();
        Vector<Word> vector = new Vector<Word>();
        int[][] nArray = new int[0][0];
        int n = configuration.getInteger("SPELL_THRESHOLD");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            List list = this.getWords(string2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                int n2 = EditDistance.getDistance(string, string3, nArray);
                if (n2 >= n) continue;
                Word word = new Word(string3, n2);
                vector.addElement(word);
            }
        }
        return vector;
    }

    public String getCode(String string) {
        return this.tf.transform(string);
    }

    protected abstract List getWords(String var1);

    public boolean isCorrect(String string) {
        List list = this.getWords(this.getCode(string));
        if (list.contains(string)) {
            return true;
        }
        return list.contains(string.toLowerCase());
    }

    public abstract /* synthetic */ void addWord(String var1);
}

