
'$INCLUDE: 'QB.BI'
'$INCLUDE: 'MOUSE.BI'
TYPE MouseFlagsType
	Active AS INTEGER
	button AS INTEGER
	Cursor AS INTEGER
END TYPE
DIM SHARED MouseFlags AS MouseFlagsType
CONST NoArg = 0
CONST FALSE = 0
CONST TRUE = NOT FALSE

'MouseBorder SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseBorder (row1%, col1%, row2%, col2%)
	IF MouseReady% = FALSE THEN ERROR 68
	MouseDriver 7, NoArg, col1%, col2%  '
											 
	MouseDriver 8, NoArg%, row1%, row2%
											 
END SUB

'MouseDriver SUB PROGRAM
'
'
'     (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseDriver (M0%, M1%, M2%, M3%)
	DIM inreg AS RegType
	DIM outreg AS RegType
	inreg.ax = M0%
	inreg.bx = M1%
	inreg.cx = M2%
	inreg.dx = M3%
	INTERRUPT &H33, inreg, outreg
	M0% = outreg.ax
	M1% = outreg.bx
	M2% = outreg.cx
	M3% = outreg.dx
END SUB

'MouseHide SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseHide
	IF MouseReady% = FALSE THEN ERROR 68
	IF MouseFlags.Cursor THEN
		MouseDriver 2, NoArg, NoArg, NoArg
		MouseFlags.Cursor = FALSE
	END IF
END SUB

'MouseInit SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseInit
	IF MouseReady% = FALSE THEN ERROR 68
	M0% = 0
	MouseDriver M0%, M1%, NoArg, NoArg
	MouseFlags.button = M1%
	MouseFlags.Active = TRUE
END SUB

'MouseLocate SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseLocate (row%, col%)
	IF MouseReady% = FALSE THEN ERROR 68
	MouseDriver 4, NoArg, col%, row%
END SUB

'MouseMode SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
'
SUB MouseMode (Func%)
	IF MouseReady% = FALSE THEN ERROR 68
	MouseHide
	IF Func% = FALSE THEN
		MouseInit
	ELSE
		CLS
		M0% = 10
		M1% = 0
		M2% = &H70FF
		M3% = &H500
		MouseDriver M0%, M1%, M2%, M3%
	END IF
END SUB

'MousePoll SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MousePoll (row%, col%, lbutton%, rbutton%)
	IF MouseReady% = FALSE THEN ERROR 68
	MouseDriver 3, M1%, M2%, M3%
	row% = M3%
	col% = M2%
	lbutton% = (M1% AND 1) <> 0
	rbutton% = (M1% AND 2) <> 0
END SUB

'MousePush SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MousePush (button%, row%, col%, lbutton%, rbutton%)
	IF MouseReady% = FALSE THEN ERROR 68
	M0% = 5
	M1% = button%
	MouseDriver M0%, M1%, M2%, M3%
	lbutton% = (M0% AND 1) = 1
	rbutton% = (M0% AND 2) = 2
	button% = M1%
	col% = M2%
	row% = M3%
END SUB

'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
FUNCTION MouseReady% STATIC
	IF NotFirstCall% THEN
	   MouseReady% = NotFirstCall%
	ELSE
		M0% = 0
		MouseDriver M0%, M1%, NoArg, NoArg
		MouseFlags.button = M1%
		MouseReady% = (M0% <> 0)
		NotFirstCall% = (M0% <> 0)
	END IF
END FUNCTION

'MouseRelease SUB PROGRAM
'
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseRelease (button%, row%, col%, lbutton%, rbutton%)
	IF MouseReady% = FALSE THEN ERROR 68
	M0% = 6
	M1% = button%
	MouseDriver M0%, M1%, M2%, M3%
	lbutton% = (M0% AND 1) = 1
	rbutton% = (M0% AND 2) = 2
	button% = M1%
	col% = M2%
	row% = M3%
END SUB

'MouseShow SUB PROGRAM
'
'      (Quick Library) MOUSE.QLB
'      (INCLUDE FILE)  QB.BI, MOUSE.BI
'
SUB MouseShow
	IF MouseReady% = FALSE THEN ERROR 68
	IF NOT MouseFlags.Cursor THEN
		MouseDriver 1, NoArg, NoArg, NoArg
		MouseFlags.Cursor = NOT FALSE
	END IF
END SUB

