/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pdftools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class PPMImage {
    int width;
    int height;
    int maxval;
    byte[] pixmap;

    public PPMImage(File file) throws IOException {
        BufferedReader imageIn = new BufferedReader(new FileReader(file));
        StreamTokenizer imageHdr = new StreamTokenizer(imageIn);
        imageHdr.commentChar(35);
        if (imageHdr.nextToken() != -3 || !imageHdr.sval.equals("P6")) {
            throw new IOException("Image file format error, raw PPM (P6) expected.");
        }
        if (imageHdr.nextToken() != -2) {
            throw new IOException("Image file syntax error, number expected.");
        }
        this.width = (int)imageHdr.nval;
        if (imageHdr.nextToken() != -2) {
            throw new IOException("Image file syntax error, number expected.");
        }
        this.height = (int)imageHdr.nval;
        if (imageHdr.nextToken() != -2) {
            throw new IOException("Image file syntax error, number expected.");
        }
        this.maxval = (int)imageHdr.nval;
        int numBytes = this.width * this.height * 3;
        this.pixmap = new byte[numBytes];
        int i = 0;
        while (i < numBytes) {
            int c = ((Reader)imageIn).read();
            this.pixmap[i] = (byte)c;
            if (c < 0) {
                throw new IOException("Premature end of file after reading " + i + " bytes.");
            }
            ++i;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxValue() {
        return this.maxval;
    }

    public byte[] getPixels() {
        return this.pixmap;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        return "PPMImage[" + this.width + "x" + this.height + " pixels]";
    }
}

