/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType5;
import org.apache.pdfbox.pdmodel.graphics.shading.Type5ShadingContext;
import org.apache.pdfbox.util.Matrix;

class Type5ShadingPaint
implements Paint {
    private static final Log LOG = LogFactory.getLog(Type5ShadingPaint.class);
    private final PDShadingType5 shading;
    private final Matrix matrix;

    Type5ShadingPaint(PDShadingType5 shading, Matrix matrix) {
        this.shading = shading;
        this.matrix = matrix;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        try {
            return new Type5ShadingContext(this.shading, cm, xform, this.matrix, deviceBounds);
        }
        catch (IOException e) {
            LOG.error("An error occurred while painting", e);
            return new Color(0, 0, 0, 0).createContext(cm, deviceBounds, userBounds, xform, hints);
        }
    }
}

